/*
 *  tml_logger.h
 *  tml
 *
 *  Created by Austin Lee.
 *
 */

#ifndef __TML_LOGGER
#define __TML_LOGGER

#include <iostream>
#include <string>

class Logger {
	
	/*
	 * -1 = print nothing
	 * 0 = print only in debug
	 * 1 = print always
	 * 2 = write to a log file as well
	 */
	int _logLevel;
	char* _logfilename;
	std::string _msg;
	int _error;
	
public:
	
	Logger(std::string filename, int level) 
	{ 
		_logfilename = (char *)filename.c_str(); 
		_logLevel = level; 
	}
	void setLogLevel(int i);
	
	void printMsg(char* s, int error=0);
	void printMsg(std::string s, int error=0);

};

#endif