/*
 *  tml_logger.cpp
 *  tml
 *
 *  Created by Austin Lee.
 *
 */

#include <iostream>
#include "tml_logger.h"
#include "tml_common_defs.h"

void Logger::printMsg(char* msg, int error)
{
	
#ifdef DEBUG 
	if( _logLevel >= 0 )
#else
	if( _logLevel >= 1 )
#endif
	{
		if( error != 0 )
			std::cout << msg << " " << getTMLError(error) << endl;
		else
			std::cout << msg << endl;
	}
}

void Logger::printMsg(std::string msg, int error)
{
	printMsg((char *)msg.c_str(), error);
}