/*
 *  tml.h
 *  try
 *
 *  Created by Austin Lee on 7/18/08.
 *  Copyright 2008 __MyCompanyName__. All rights reserved.
 *
 */

#ifndef __tml_h
#define __tml_h

#include <stdio.h>
#include <stdlib.h>
#include <string>
#include <vector>
#include <map>
#include <iterator>

const int max_line_num = 256;

using namespace std;

/*
 * Class defintion for the symbol table
 *
 * I will use an associative map to maintain (key,element) pairs
 * key is the variable name and element is its type
 * access functions such as insert and lookup will be provide so that
 * if a different data structure other than the map is used in the future
 * the interface won't be affected
 */
class SymbolTable { 
	
	map<string,string> _table;
	
public:
	
	//inserts identifier into the symbol table
	void insert(string key, string val);
	
	//checks to see if identifier id is already in the table
	bool lookup(string id);
	
	//clean up memory taken up by the symbol table
	void cleanup();
	
	string findValueByKey(string key);
	
};

typedef enum {
	TML_NO_ERROR=0,
	TML_FILE_NOT_FOUND,
	TML_SYNTAX_ERROR_INVALID_VALUE,
	TML_NO_MATCH_FOUND,
	TML_UNEXPECTED_ERROR
} TML_ERROR;
	
typedef struct {
	int from;
	int to;
} Quantifier;

typedef enum {
	CHAR = 0,
	DOT,
	TAB,
	BOL,
	EOL,
	SPACE,
	WS,
	DIGIT,
	NONDIGIT,
	WORD,
	NONWORD
} CharSet;

typedef struct {
	string strLiteral;
	CharSet ch;
	int ascii;
} StringLiteral;

typedef struct {
	int from;
	int to;
} CharacterClass;

typedef struct {
	int i;
	string cc;
	string s;
} PatternAtomType;

class MyBasicVar {
	string _name;
	
public:
	void setVarName(string varName) { _name = varName; }
	string getVarName() { return _name; }
};


class InputFile : public MyBasicVar {
	
	bool _isList;
	vector<string> _list;  
	
public:
	
	//true = contains list of input files
	void setType(bool list=false) { _isList = list; }
	void setFileList(vector<string> list)
	{
		_list = list;
	}
	vector<string> getFileList()
	{
		//vector<string>::iterator pos;
		
		/*if( _list.size() == 0 )
		{
			printf("Error: No file defined\n");
			exit(0);
		}*/
		
		/*for( pos = _list.begin() ; pos != _list.end() ; ++pos )
		{
			list->push_back((*pos));
		}*/
		return _list;
	}
	
};

typedef enum {
	FIND_ONLY = 0,
	REPLACE,
//	DELETE
} SearchAction;


template <class T> 
class ListHandler {
	
	vector<T*> _list;
	
public:
	
	//assumes that a check against the Symbol Table has been done
	//to determine this variable exists
	T* findByName(string p)
	{
		typename std::vector<T*>::iterator pos;
		T * ret = NULL;
		int i=0;
		for( pos = _list.begin() ; pos != _list.end() ; ++ pos, ++i )
		{
			if( p.compare( (*pos)->getVarName() ) == 0 )
				ret = _list.at(i);
		}
		
		return ret;				
	}
	
	void remove(string p)
	{
		typename std::vector<T*>::iterator pos;
		T* ret = NULL;
		int i=0;
		for( pos = _list.begin() ; pos != _list.end() ; ++ pos, ++i )
		{
			if( p.compare( (*pos)->getVarName() ) == 0 )
			{
				ret = _list.at(i);
				_list.erase(pos);
			}
		}
		
		//this was allocated with new
		delete ret;
	}
	
	void add(T* p) 
	{ 
		_list.push_back(p); 
	}
	
	void cleanup()
	{
		
	}
	
};

string genOutFileName(string in);
char* getTMLError(int error);

#endif
