/*
 *  tml_common_defs.cpp
 *  try
 *
 *  Created by Austin Lee on 7/31/08.
 *  Copyright 2008 __MyCompanyName__. All rights reserved.
 *
 */

#include <iostream>
#include <string>
#include <fstream>
#include <sstream>
#include "tml_common_defs.h"
#include "tml_logger.h"

extern Logger* lg;

using namespace std;
//using namespace boost;

/*
 * inserts identifier into the symbol table
 * key is the identifier and val is the typename
 */
void SymbolTable::insert(string key, string val)
{
	_table.insert(map<string,string>::value_type(key,val));
}
	
//checks to see if identifier id is already in the table
bool SymbolTable::lookup(string id)
{
	//map<string,string>::iterator pos;
	
	if( _table.find(id) == _table.end() )
		return false;
	else
		return true;
}

string SymbolTable::findValueByKey(string key)
{
	map<string,string>::iterator pos;
	for( pos = _table.begin() ; pos != _table.end() ; ++pos )
	{
		if( pos->first == key )
			return pos->second;
	}
	
	return "";	
}

void SymbolTable::cleanup()
{
	//remove all elements
	//_table.clear();
	//free memory
	//_table.~map();
}

string genOutFileName(string in)
{
	string ret;
	
	ret = in + ".tmp";
	
	return ret;
}


char* getTMLError(int error)
{
	TML_ERROR e = (TML_ERROR)error;
	char* ret = NULL;
	switch (e)
	{
		case TML_NO_ERROR:
			break;
		case TML_FILE_NOT_FOUND:
			ret = "File Not Found";
			break;
		case TML_SYNTAX_ERROR_INVALID_VALUE:
			ret = "Syntax Error - Invalid value";
			break;
		case TML_NO_MATCH_FOUND:
			ret = "No Match Found for Given Pattern";
			break;
		case TML_UNEXPECTED_ERROR:
		default:
			ret = "Unknown Error";
			break;
	}//end of switch 
	
	return ret;
}