/*
 * Created by Austin Lee for COMS4115 PST
 *
 * Driver source that contains main for the TML program
 * Simply reads in the input file and invokes antlr
 * to tokenize, parse and generate the AST tree
 *
 */

#include <iostream>
#include <sstream>
#include <stdio.h>
#include <stdlib.h>
#include <string>
#include "antlr/AST.hpp"
#include "TMLLexer.hpp"
#include "TMLParser.hpp"
#include "TMLTreeWalker.hpp"
#include "CharInputBuffer.hpp"
#include "tml_common_defs.h"
#include "TMLTreeWalkerHelper.h"
#include "tml_logger.h"

//Singleton logger object to be used through the program
Logger* lg;

/* 
 * 1st argument must be the .tml file to be translated/interpreted
 */
int main(int argc, char* argv[]) 
//int main()
{
	ANTLR_USING_NAMESPACE(std)
	ANTLR_USING_NAMESPACE(antlr)
	
	string filename = "re1.tml";
	FILE* inputFile = NULL;

	//0 - print only in debug
	//1 - always print
	lg = new Logger("tml_debug.txt",0);
	
	if( argc > 1 )
	{
		ostringstream ostr;
		istringstream tmpFileName;
		ostr << argv[1];
		tmpFileName.str(ostr.str());
		filename = tmpFileName.str();
	}
	else
	{
		cout << "Usage: tml <tml_file.tml>\n";
#ifndef DEBUG 
		exit(0);
#endif
	}
		
	inputFile = fopen(filename.c_str(), "r");
	fseek(inputFile, 0L, SEEK_END);
	int size, readSize;
	size = ftell(inputFile);
	char* input = new char[size];
	fseek(inputFile, 0L, SEEK_SET);
	readSize = fread((void *)input, 1, size, inputFile);
	fclose(inputFile);
	if( size != readSize ) {
		cout << "Unable to read the whole input file\n";
		exit(0);
	}
	
	try
	{

		CharInputBuffer cib((unsigned char *)input,size);
		TMLLexer lexer(cib);
		lexer.setFilename(filename.c_str());
		TMLParser parser(lexer);
		parser.setFilename(filename.c_str());
	
		ASTFactory ast_factory;
		parser.initializeASTFactory(ast_factory);
		parser.setASTFactory(&ast_factory);
		
		parser.program();
		RefAST t = parser.getAST();
		if( t )
		{
			lg->printMsg(t->toStringTree(),0);
			TMLTreeWalker walker;
			int r = walker.program(t);
			lg->printMsg("TML execution result = ",r);
		}
		
		symbtable.cleanup();
		
	}
	catch(ANTLRException& e)
	{
		cerr << "Parse exception: " << e.toString() << endl;
		return -1;
	}
	catch(exception& e)
	{
		cerr << "exception: " << e.what() << endl;
		return -1;
	}
	
	delete [] input;
	delete lg;
	
	return 0;
}
