##!/bin/sh

echo "Running TML regression test suites"

tml=`pwd`/tml
if [ -n "$1" ]
then
  count="$1"
else
  count=1
fi

tc="tc"
index=1
while [ $index -le $count ] 
do
  echo "Running TC$index ..."
  $tml "$tc$index/re$index.tml"
  if [ -e "$tc$index/input.txt.tmp" ]
  then
    res=`diff $tc$index/input.txt.out $tc$index/input.txt.tmp`
    if [ -n "$res" ]
      then 
        echo "Failed" > "result$index.txt"
      else
        echo "Passed" > "result$index.txt"
      fi
    else
      echo "Failed, no output generated" > "result$index.txt"
    fi
  index=$(($index+1))
done

index=1
filecount=5
echo "Running the default file_list TC..."
$tml "tc0/re0.tml"
while [ $index -le $filecount ]
do
  res=`diff tc0/f$index.txt.out tc0/f$index.txt.tmp`
  if [ -n "$res" ]
  then
    echo "$index failed" >> "result0.txt"
  else
    echo "$index passed" >> "result0.txt"
  fi
  index=$(($index+1))
done

echo "Tests completed"

echo "Test Results"
grep -i pass result*
grep -i fail result*

