/*
 *  search.h
 *  tml
 *
 *  Created by Austin Lee.
 *
 */

#ifndef __SEARCH_H
#define __SEARCH_H

#include "tml_common_defs.h"
#include "pattern.h"

class Search : public MyBasicVar {
	bool _case;         //true = case-sensitivte (default), false = case-insensitive
	bool _singleLine;   //true = treat input line as single line, false = treat input as multi-line
	bool _reset;        //true = set the /G option, false is default
	bool _bw;
	bool _ew;
	
	//string _code;
	Pattern* _p;
	vector<string> _matched;
	SearchAction _action;
	string _replace;
	InputFile* _input;
	
	string constructPattern();
	
public:
	
	void setDefaults() 
	{
		setSearchAction(FIND_ONLY);
		setCase(true);
		setLineMode(true);
		setResetMode(false);
		setBeginsWith(false);
		setEndsWith(false);
	}
	
	void setCase(bool caseSensitive=true) { _case = caseSensitive; }
	void setLineMode(bool mode=true) { _singleLine = mode; }
	void setResetMode(bool mode=false) { _reset = mode; }
	void setPattern(Pattern *p) { _p = p; }
	void setSearchAction(SearchAction a=FIND_ONLY) { _action = a; }
	void setReplaceString(string str) { _replace = str; }
	void setInput(InputFile* in) { _input = in; }
	void setBeginsWith(bool b=false) { _bw=b; }
	void setEndsWith(bool e=false) { _ew=e; }
	
	//void setCode(string code) { _code = code; }
	//void executeCodeSection();
	
	//Input can be a string or a file or a list of files
	int performSearch();
	//int performSearch(Input *in);
	//int performSearch(Input *in, Output *out);  //might be necessary..
	
	//the following two use _matched for backreferencing
	//string getMatched(int index);
	//string getLastMatched(int index);
	
	Pattern* getPattern() { return _p; }
	string getReplaceString()
	{
		//return a copy, not the actually thing
		string tmp(_replace);
		return tmp;
	}
	
	InputFile* getInput() { return _input; }
	bool isReset() { return _reset; }
	
};

#endif
