/*
 *  search.cpp
 *  tml
 *
 *  Created by Austin Lee.
 *
 */

#include <fstream>
#include <sstream>
#include "search.h"
#include "boost/regex.hpp"
#include "tml_logger.h"

extern Logger* lg;

using namespace std;

//performs search on this
int Search::performSearch()
{
	int ret=0;
	bool found=false;
	
	//use Perl style regexp
	boost::regex::flag_type mType = boost::regex::perl;
	//if case-insensitive
	if( _case == false )
		mType = mType | boost::regex::icase;
	
	string p = getPattern()->getRegExp();
	
	//for testing only
	//p = "(word\\s)";
	//string r = " found ";
	//setReplaceString(r);
	
	if( _bw )
		p = "^" + p;
	if( _ew )
		p = p + "$";
	
	lg->printMsg("Regular Expression:",0);
	lg->printMsg(p,0);
	
	boost::regex reg(p,mType);
	
	vector<string> filelist;
	if( getInput() != NULL )
		filelist = getInput()->getFileList();
	else
	{
		lg->printMsg("Error: no input file was specified for Search ",0);
		lg->printMsg(getVarName(),0);
		exit(0);
	}
	
	vector<string>::iterator pos;
	std::ifstream from;
	std::ofstream to;
	char str[max_line_num];
	memset(str,0,max_line_num);
	int line_num,position;
	
	string msg;
	ostringstream ostr;
	
	for( pos = filelist.begin() ; pos != filelist.end() ; ++pos )
	{
		from.open((*pos).c_str(),ios_base::in);
		if( from.is_open() == false )
			lg->printMsg("In performSearch",(int)TML_FILE_NOT_FOUND);
		
		string outFilename = genOutFileName((*pos).c_str());
		to.open(outFilename.c_str(),ios_base::out | ios_base::trunc);
		if( to.fail() )
		{
			lg->printMsg("In performSearch",(int)TML_FILE_NOT_FOUND);
			exit(0);
		}
		
		line_num = 1;
		
		while( from.getline(str,max_line_num) )
		{
			string s(str);
			switch( _action )
			{
				case FIND_ONLY:
				{
					boost::smatch m;
					boost::match_flag_type flags = boost::match_default;
					
					//if isReset = true, then we search the rest of the input for more matches
					if( isReset() )
					{
						string::const_iterator pos = s.begin();
						string::const_iterator e_pos = s.end();
						int repeat=1;
						int subMatchCount = 0;
						
						
						while( boost::regex_search(pos,e_pos,m,reg,flags) )
						{
							subMatchCount = m.size();
							
							if( repeat )
							{
								ostr << "Line " << line_num << ":";
								repeat = 0;
							}
							
							for( int i=1 ; i <= subMatchCount ; ++i )
							{
								//this is only if sub-patterns are matched
								if( m[i].matched )
								{
									string match_str(m[i].first,m[i].second);
									position = (m[i].first - s.begin())+1;
									
									msg = p + " matched " + m[i].str();
									lg->printMsg(msg,0);
									
									ostr << " (pos: " << position << ") " << m[i];
								}
							}
							//go to the end of the current match
							pos=m[0].second;
						}
					}
					else
					{
						found = boost::regex_search(s, m, reg, flags);
						//here we only care about the first match
						if( m[0].matched )
						{
							string match_str(m[0].first,m[0].second);
							position = (m[0].first - s.begin())+1;
							
							msg = p + " matched " + m[0].str();
							lg->printMsg(msg,0);
							
							ostr << "Line " << line_num	<< ": (pos: " << position << ") " << m[0];
						}
					}
					break;
				}
				case REPLACE:
				{
					string replaceStr = getReplaceString();
					if( replaceStr.length() == 0 ) 
					{
						//Error - no replace string provided
					}
					s = boost::regex_replace(s, reg, replaceStr);
					ostr << s;
					break;
				}
					//case DELETE:
					//	break;
				default:
					break;
			}
			
			//if a match was found
			if( ostr.str().length() > 0 )
			{
				ostr << endl;
				s = ostr.str();
				to.write(s.c_str(),s.size());
				to.flush();
			}
			memset(str,	0, max_line_num);
			++line_num;
			//reset the outstream string buffer
			ostr.str("");
		}
		
		from.close();
		to.close();
	}
	
	return ret;
}
