/*
 *  pattern.h
 *  tml
 *
 *  Created by Austin Lee.
 *
 */

#ifndef __PATTERN_H
#define __PATTERN_H

#include "tml_common_defs.h"

class Pattern : public MyBasicVar {
	
	bool _capture;
	bool _greedy;
	bool _group;    //true = patterns are alternatives (p1 | p2 | p3), false is default
	bool _charClass;  //treat the pattern as a character class
	bool _begins;
	bool _ends;
	
	string _regexp;
	
	Quantifier _qf;
	CharacterClass _class;
	vector<Pattern> _groupList;
	//vector<Pattern> _andList;
	
	//a pattern can be a sequence of patterns
	vector<Pattern> _patternList;
	//sequence of string literals
	vector<StringLiteral> _sl;
	vector<string> _strExprList;
	
public:
	
	Pattern()
	{
		_capture=true;
		_greedy=true;
		_group=false;
		_charClass=false;
		_begins=false;
		_ends=false;
		_qf.from=-1;
		_qf.to=-1;
	}
	
	void setCapture(bool capture=true) { _capture = capture; }
	void setGreedy(bool greedy=true) { _greedy = greedy; }
	void setGroup(bool group=false) { _group = group; }
	void setClass(bool isClass=false) { _charClass = isClass; }
	
	void setStringLiteral(string str);
	void setStringLiteral(vector<StringLiteral> str) 
	{ 
		_sl.clear();
		copy(str.begin(),str.end(),back_inserter(this->_sl)); 
	}
	
	void setPatternList(vector<Pattern> plist) 
	{ 
		_patternList.clear();
		copy(plist.begin(),plist.end(),back_inserter(this->_patternList));
	}
	//void setLocationType(LocatioinType loc=NONE) { _loc = loc; }
	void setRegExp(string str) { _regexp = str; }
	
	string getRegExp() { return _regexp; }
	
	void setQuantifierOption(int from, int to) { _qf.from = from; _qf.to = to; }
	void setCharacterClass(int from, int to) { _class.from = from; _class.to = to; }
	
	vector<Pattern> getPatternList()
	{
		vector<Pattern> tmp;
		copy(_patternList.begin(),_patternList.end(),back_inserter(tmp));
		return tmp;
	}
	
	//checks to see if the pattern is valid or not
	//might want to return some debugging information so user knows what to fix..
	//bool isValidPattern(Pattern p);
	//bool isValidPattern();
	
	void addToStrExprList(string str)
	{
		_strExprList.push_back(str);
	}
	
	int addToSubPatternList(Pattern p) 
	{ 
		Pattern tmp;
		tmp = p;
		_patternList.push_back(tmp); 
		return 0; 
	}
	int addToGroupList(Pattern p)      { _groupList.push_back(p); return 0; }
	//int addToAndList(Pattern p)        { _andList.push_back(p); return 0; }
	
	void printPatternList();
	
	string constructPattern();
	string constructStringLiteral();
	//string constructClassPattern();
	string constructGroupPattern();
	string concatPatternList();
	
	void makeSubPattern()
	{
		_regexp = "(" + _regexp + ")";
	}
	
	Pattern& operator= (const Pattern& p)
	{
		_capture   = p._capture;
		_greedy    = p._greedy;
		_group     = p._group;
		_charClass = p._charClass;
		_regexp    = p._regexp;
		_qf        = p._qf;
		_class     = p._class;
		this->_regexp    = p._regexp;
		//_groupList = p._groupList;
		//_patternList = p._patternList;
		//_sl        = p._sl;
		this->setVarName(((Pattern)p).getVarName());
		this->_groupList.clear();
		this->_patternList.clear();
		this->_strExprList.clear();
		copy(p._groupList.begin(),p._groupList.end(),back_inserter(this->_groupList));
		copy(p._patternList.begin(),p._patternList.end(),back_inserter(this->_patternList));
		copy(p._strExprList.begin(),p._strExprList.end(),back_inserter(this->_strExprList));
		//copy(p._sl.begin(),p._sl.end(),back_inserter(this->_sl));
		vector<StringLiteral>::const_iterator pos = (p._sl).begin();
		for( ; pos != (p._sl).end() ; ++pos )
		{
			StringLiteral tmp;
			tmp.strLiteral = (*pos).strLiteral;
			tmp.ch = (*pos).ch;
			tmp.ascii = (*pos).ascii;
			_sl.push_back(tmp);
		}
		return *this;
	}
};

#endif