/*
 *  pattern.cpp
 *  tml2
 *
 *  Created by Austin Lee on 8/11/08.
 *  Copyright 2008 __MyCompanyName__. All rights reserved.
 *
 */

#include <sstream>
#include "pattern.h"
#include "tml_logger.h"

extern Logger* lg;

void Pattern::setStringLiteral(string str)
{
	StringLiteral sl;
	sl.strLiteral = str;
	_sl.push_back(sl);
}

string Pattern::constructPattern()
{
	string ret;
	
	vector<string>::const_iterator pos;
	for( pos = _strExprList.begin() ; pos != _strExprList.end() ; ++pos )
	{
		if( *pos != "" )
			ret += *pos;
		else
		{
			//Error!
			lg->printMsg("In constructPattern ",(int)TML_SYNTAX_ERROR_INVALID_VALUE);
		}
	}
	
	ostringstream ostr;
	
	if( _qf.from != -1 || _qf.to != -1 )
	{
		int a,b;
		a = _qf.from;
		b = _qf.to;
		if( a != -1 && b != -1 )
			ostr << "{" << a << "," << b << "}";
		else if( a == -1 )
			ostr << "{0," << b << "}";
		else if( b == -1 )
			ostr << "{" << a << ",}";
		else 
		{
			//Error
			lg->printMsg("In constructPattern ",(int)TML_SYNTAX_ERROR_INVALID_VALUE);
		}
		if( !_greedy )
			ostr << "?";
	}
	
	ret += ostr.str();
	
	_regexp = ret;
	
	return ret;
}

string Pattern::constructGroupPattern()
{
	string ret = "(";
	string regexp;
	
	vector<Pattern>::iterator pos;
	
	for( pos = _patternList.begin() ; pos != _patternList.end() ; ++pos)
	{
		//strip "(" and ")" before adding to the group
		//to avoid creating an unnecessary subpattern
		//"(" and ")" will be applied to the whole group
		//so that the alternative that gets matched becomes
		//the subpattern for the group
		if( (*pos)._regexp.substr(0,1).compare("(") == 0 )
			regexp = (*pos)._regexp.substr(1,(*pos)._regexp.length() - 2);
		else
			regexp = (*pos)._regexp;
		
		if( pos == _patternList.begin() )
			ret += regexp;
		else
			ret += "|" + regexp;	
	}
	
	ret += ")";
	_regexp = ret;
	return ret;
}

string Pattern::concatPatternList()
{
	string ret;
	
	vector<Pattern>::iterator pos;
	
	for( pos = _patternList.begin() ; pos != _patternList.end() ; ++pos)
	{
		ret += (*pos)._regexp;
	}
	
	this->_regexp = ret;
	return ret;
}

void Pattern::printPatternList()
{
	vector<Pattern>::iterator pos;
	for( pos = _patternList.begin() ; pos != _patternList.end() ; ++pos)
	{
		if( (*pos)._patternList.size() > 0 )
		{
			(*pos).printPatternList();
		}
		else
		{
			string msg = "(" + (*pos).getVarName() + ": " + (*pos)._regexp + ")";
			lg->printMsg(msg,0);
		}
	}
}

string Pattern::constructStringLiteral()
{
	string ret;
	vector<StringLiteral>::const_iterator pos;
	for( pos = _sl.begin() ; pos != _sl.end() ; ++pos )
	{
		if( (*pos).strLiteral != "" )
			ret += (*pos).strLiteral; 
	}
	
	ostringstream ostr;
	
	if( _qf.from != -1 || _qf.to != -1 )
	{
		int a,b;
		a = _qf.from;
		b = _qf.to;
		if( a != -1 && b != -1 )
			ostr << "{" << a << "," << b << "}";
		else if( a == -1 )
			ostr << "{0," << b << "}";
		else if( b == -1 )
			ostr << "{" << a << ",}";
		else 
		{
			//Error
		}
		if( !_greedy )
			ostr << "?";
	}
	
	ret += ostr.str();
	
	return ret;
}
