header "pre_include_hpp"
{
}	
header "post_include_hpp"
{
}
header "pre_include_cpp"
{
}
header
{
  #include "TMLTreeWalkerHelper.h"
  #include "tml_common_defs.h"
}
options 
{ 
  language = "Cpp"; 
}
{
}

class TMLLexer extends Lexer;

options { testLiterals=false; k=2; }

ASSIGN 	: '=' ;
//PARENS options { testLiterals = true; }
//	: '(' | ')' ;
LPAREN	: '(' ;
RPAREN	: ')' ;
LBRACE	: '{' ;
RBRACE 	: '}' ;
LBRACK	: '[' ;
RBRACK 	: ']' ;
ALTER	: '|' ;
COMMA	: ',' ;
SEMI	: ';' ;
PERIOD 	: '.' ;
SQUOTE	: "'" ;
DASH	: '-' ;
DOLLAR	: '$' ;
AND		: '&' '&' ;
COMMENT : "//" (~('\r'|'\n'))* ('\r')? '\n' { _ttype = ANTLR_USE_NAMESPACE(antlr)Token::SKIP; } ;
protected LETTER
	: ('a' .. 'z' | 'A' .. 'Z') ;
protected DIGIT
	: '0' .. '9' ;

ID options { testLiterals = true; }
	: (LETTER | '_') (LETTER | DIGIT | '_')* ;
NUMBER 	: (DIGIT)+ ;
STRING	: '"'! ('"' '"'! | ~('"'))* '"'! ; // '"
WS	: (' ' | '\t' | '\n' { newline(); } | '\r' )+ { _ttype = ANTLR_USE_NAMESPACE(antlr)Token::SKIP; } ;
ESC : '\\' (~('a' .. 'z'|'A' .. 'Z'|'0'..'9'))
	;
	
class TMLParser extends Parser;
options { buildAST = true; k = 2; }

program	: (statement SEMI!)* EOF!
	;

statement
	: varDeclaration 
	| copyStatement
	| regexpStatement
	;

varDeclaration
	: varType ID^ (COMMA! ID)*
	;

varType
	: "pattern" | "search" | "file" | "file_list" | "string"
	;

patternExpression
	: (subPatternExprs)+
	  {#patternExpression = #([PATTERNLIST,"PATTERNLIST"], patternExpression); }
	; 

subPatternExprs
	: LPAREN! (ID | compositePattern) groupPatternExprs RPAREN!
	;
	
groupPatternExprs
	: (ALTER! (ID | compositePattern))*
	  {#groupPatternExprs = #([GROUPLIST,"GROUPLIST"], groupPatternExprs); }
	;

compositePattern
	: (LPAREN)? singletonPattern (patternQuantifier)? (RPAREN)?
	;
	
singletonPattern	
	: (stringExpression
	| classExpression)+
	  {#singletonPattern = #([ATOMLIST,"ATOMLIST"], singletonPattern);}
	;

stringExpression
	: characterExpression | STRING
	;

//patternLocationSpecifier
//	: "beginsWith" | "bw"
//	| "endsWith" | "ew"
//	;

patternQuantifier
	: "optional"
	| (NUMBER)? DASH (NUMBER)?
	; 
	
characterExpression
	: "dot"
	| "tab"
	| "bol"
	| "eol"
	| "space"
	| "ws"
	| "digit"
	| "nondigit"
	| "word"
	| "nonword"
	;

classExpression
	: LBRACK! ("except")? charClassList RBRACK!     
	;

charClassList
	: (charClass)+
	  {#charClassList = #([CHARCLASSLIST,"CHARCLASSLIST"], charClassList);}
	;
	
charClass
	: ESC | NUMBER | ID | DOLLAR | DASH;
	
patternExpressionReference
	: "match"^ LBRACK! NUMBER RBRACK!
	| "lastmatch"^ LBRACK! NUMBER RBRACK!
	;

//searchOptionDefinition
//	: "s_type" ASSIGN^ ("single" | "array")
//	| "s_input" ASSIGN^ ID
//	| "s_action" ASSIGN^ ("replace" | "delete")
//	| "s_mode" ASSIGN^ searchMode
//	| "s_pattern" ASSIGN^ ID
//	| "s_code" ASSIGN^ LBRACE! (ascii)* RBRACE!
//	| "s_replace" ASSIGN^ (ID | STRING)
//	;

//searchMode
//	: "case"
//	| "nocase"
//	| "beginsWith"
//	| "endsWith"
//	| "reset"
//	;

// <stuff on the left> = <stuff on the right>
copyStatement
	: ID^ (PERIOD^ modes)? ASSIGN^
	( (stringLiteral) => thisStringLiteral 
	| patternExpressionReference
	| patternExpression
	| ID )
	;

stringLiteral
	: STRING
	;
	
thisStringLiteral
	: STRING
	;

modes
	: "s_mode"
	| "s_type"
	| "s_action"
	| "s_pattern"
	| "s_input"
	| "s_replace"
	| "noncapture"
	| "greedy"
	;
	
regexpStatement
	: "regexp_engine"^ LPAREN! (ID)? RPAREN!
	;

{
	#include <string>
	#include <iostream>
}

class TMLTreeWalker extends TreeParser;
{
	
}
program returns [int i] 
{ int foo = 0; }
	: (foo=statement { i=foo; })*
	;

statement returns [int i]
{ 
	i = 0; 
	std::string vName, rval; 
	char* vType; 
	char* optionValue = NULL;
	Pattern rPattern,tmp;
} 
	  //case for copyStatement
	: #(ASSIGN 
		(#(PERIOD left2:ID optionValue=flags { vName = left2->getText(); }) | 
				  left1:ID { vName = left1->getText(); }) 
	    (right2:STRING { rval = right2->getText(); setDefinition(vName,rval,optionValue); } |
		 (right1:ID { rval = right1->getText(); } 		  
		 { setDefinition(vName,rval,optionValue); }) |
		  #(PATTERNLIST {rPattern.setVarName(vName);} 
		    (tmp=subExpr { rPattern.addToSubPatternList(tmp);})+ 
		  	 { patternDefinition(rPattern); }) 
		))
		  
	| #(left:ID { vName = left->getText(); } vType=varType { declaration(vType,vName); } 
	    (right:ID { vName = right->getText(); declaration(vType,vName); })*) 

	| #("regexp_engine" sName:ID { executeSearch(sName->getText()); } )
	
	;
	
subExpr returns [Pattern p4]
{ 
	Pattern tmp2,tmp3;
	bool isGroup = false;
}
	: ((id1:ID 
		{
			Pattern tmp;
			tmp.setVarName(id1->getText());
			//cout << "id = " << id1->getText() << endl;
			verifyPatternID(id1->getText());
			resolveID(&tmp);
			p4.addToSubPatternList(tmp);
		}			
	  | tmp2=patternExpr
		{
			Pattern tmp4;
			tmp2.constructPattern();
			tmp4 = tmp2;
			p4.addToSubPatternList(tmp4);
		} 
		)
		(tmp3=groupExpr
		{
			for( int i=0 ; i < tmp3.getPatternList().size() ; ++i )
			{
				p4.addToSubPatternList(tmp3.getPatternList().at(i));
			}
			p4.constructGroupPattern();
			isGroup = true;
		})
		)
		{
			if( !isGroup )
			{
				//p4.makeSubPattern();
			}
		}
	;
	
groupExpr returns [Pattern p3]
{
	Pattern tmp;
}
	: #(GROUPLIST
	   ((id2:ID 
		{
			Pattern tmp1;
			tmp1.setVarName(id2->getText());
			//cout << "In group, id = " << id2->getText() << endl;
			verifyPatternID(id2->getText());
			resolveID(&tmp1);
			p3.addToSubPatternList(tmp1);
		})			
	  | (tmp=patternExpr
		{
			Pattern tmp2;
			tmp.constructPattern();
			tmp2 = tmp;
			p3.addToSubPatternList(tmp2);
		})
	  )*
	  )
	;

//compositePattern
patternExpr returns [Pattern p2]
{
	//Pattern ret,tmp;
	//ret.setLocationType(NONE);
	int a,b;
}
	: p2=subPatternExpr
	   (("optional" 
	     {
		 	a=0,b=1;
		 } | 
	   (from:NUMBER)? DASH (to:NUMBER)? 
	     { 
		 	if( from == NULL )
			{
				p2.setGreedy(false);
				a = -1;
			}
			else
				a = atoi(from->getText().c_str());
			
			if( to == NULL )
			{
				p2.setGreedy(true);
				b = -1;
			}
			else
				b = atoi(to->getText().c_str());
		 }) 
	   { p2.setQuantifierOption(a,b);} )?
	   { }
	;
	
subPatternExpr returns [Pattern p1]
{
	char* t;
}
	: #(ATOMLIST (t=exprAtom
		{
			string tmp(t);
			p1.addToStrExprList(tmp);
		})+)
	;
	
exprAtom returns [char* t]
{
	char* tmp;
	std::string ret = "";
}
	: (("except" {ret="[^";})? 
	  #(CHARCLASSLIST 
	  (tmp=charClass 
	  {
	    string tmp2(tmp);
		if( ret.length() == 0 )
			ret = "[";
		ret += tmp2; 
	  })+) { ret += "]"; t = (char *)ret.c_str(); })
	| (tmp=singleChar
	  {
	    string tmp2(tmp);
		t = (char *)tmp2.c_str();
	  }
	  { })
	;
	
charClass returns [char* cc]
{

}
	: id1:ESC { cc = (char *)id1->getText().c_str(); }
	| id2:NUMBER { cc = (char *)id2->getText().c_str(); }
	| id3:ID { cc = (char *)id3->getText().c_str(); }
	| DOLLAR { cc = "$"; }
	| DASH { cc = "-"; }
	;
	
singleChar returns [char* sc]
{
	sc = NULL;
}
	: "dot"			{ sc = "."; }
	| "tab"			{ sc = "\\t"; }
//	| "bol"			{ sc = "bol"; }
	| "eol"			{ sc = "\\n"; }
	| "space"		{ sc = "\\s"; }
	| "ws"			{ sc = "\\s*"; }
	| "digit"		{ sc = "\\d"; }
	| "nondigit"	{ sc = "\\D"; }
	| "word"		{ sc = "\\w"; }
	| "nonword"		{ sc = "\\W"; }
	| str:STRING	{ sc = (char *)str->getText().c_str(); }
	;
	
varType returns [char* t]
	: "pattern" { t = "pattern"; } 
	| "search" { t = "search"; } 
	| "file" { t = "file"; } 
	| "file_list" { t = "file_list"; }
	;

flags returns [char* t]
	: "noncapture"	{ t = "noncapture"; }
	| "greedy"		{ t = "greedy"; }
	| "s_mode"		{ t = "mode"; }
	| "s_input"		{ t = "input"; }
	| "s_type"		{ t = "type"; }
	| "s_pattern"	{ t = "pattern"; }
	| "s_replace"	{ t = "replace"; }
	| "s_action"	{ t = "action"; }
	;



















