/*
 *  TMLTreeWalkerHelper.h
 *  try
 *
 *  Created by Austin Lee on 7/31/08.
 *  Copyright 2008 __MyCompanyName__. All rights reserved.
 *
 */

#ifndef __TMLTreeWalkerHelper_h
#define __TMLTreeWalkerHelper_h

#include "tml_common_defs.h"
#include "search.h"
#include "pattern.h"

//only need one for the language
static SymbolTable symbtable;

/************************************************************************************
 *                     Functions needed by TMLWalker.cpp
 ***********************************************************************************/

void declaration(char* varTypeName, string id);

void setDefinition(string varName, string rVal, char* optionValue);

void fileDefinition(string id, string rvalue, bool isList);

void patternDefinition(string lval, string rval,char* optionValue);
void patternDefinition(Pattern p);

void searchDefinition(string lval, string rval,char* optionValue);
void searchOptionDefinition(string lval, string option, string rval);

void verifyPatternID(string pName);
void resolveID(Pattern* p);

void executeSearch(string s);

#endif
