/*
 *  TMLTreeWalkerHelper.cpp
 *  try
 *
 *  Created by Austin Lee on 7/31/08.
 *  Copyright 2008 __MyCompanyName__. All rights reserved.
 *
 */

#include <iostream>
#include <sstream>
#include <fstream>
#include <string>
#include "TMLTreeWalkerHelper.h"
#include "tml_logger.h"

extern Logger* lg;

using namespace std;

ListHandler<Pattern> patternListHandler;
ListHandler<Search>  searchListHandler;
ListHandler<InputFile> inputFileListHandler;

void declaration(char* varTypeName, string id)
{
	string msg(varTypeName);
	msg += " " + id;
	lg->printMsg(msg,0);
	
	if( true == symbtable.lookup(id))
	{
		lg->printMsg(id, (int)TML_SYNTAX_ERROR_INVALID_VALUE);
	}
	else {
		string s(varTypeName);
		symbtable.insert(id, s);
	}
}

void setDefinition(string varName, string rval, char* optionValue)
{
	if( true == symbtable.lookup(varName) )
	{
		string typeName;
		typeName = symbtable.findValueByKey(varName);
		
		if( typeName.compare("pattern") == 0 )
		{
			patternDefinition(varName, rval,optionValue);
		}
		else if( typeName.compare("search") == 0 )
		{
			searchDefinition(varName, rval,optionValue);
		}
		else if( typeName.compare("file") == 0 )
		{
			fileDefinition(varName, rval, false);
		}
		else if( typeName.compare("file_list") == 0 )
		{
			fileDefinition(varName, rval, true);
		}
		else
		{
			lg->printMsg("In setDefinition",(int)TML_UNEXPECTED_ERROR);
		}
		
	}
	else 
	{
		cout << "Error: " << varName << " not found\n";
		string msg(varName);
		msg = "In setDefinition " + msg;
		lg->printMsg(msg,(int)TML_SYNTAX_ERROR_INVALID_VALUE);
	}
}

void fileDefinition(string lval, string rvalue, bool isList)
{
	bool found=false;
	InputFile* in;
	if( (in = inputFileListHandler.findByName(lval)) == NULL )
	{
		in = new InputFile;
		in->setType(false);
		in->setVarName(lval);
		found = false;
	}
	else 
		found = true;
	
	vector<string> list;
	if( !isList )
	{		
		list.push_back(rvalue);
	}
	else 
	{
		ifstream from;
		from.open(rvalue.c_str(),ios_base::in);
		char filename[max_line_num];
		while( from.getline(filename,max_line_num) )
		{
			string s(filename);
			list.push_back(s);
		}
		
	}
	
	in->setFileList(list);
	
	if( !found )
	{
		inputFileListHandler.add(in);
	}

}

/*
 * Pattern is defined as a simple string literal
 */ 
void patternDefinition(string lval, string rval,char* optionValue)
{
	Pattern* p = new Pattern;
	string regexp;
	p->setVarName(lval);
	p->setStringLiteral(rval);
	regexp = "(" + rval + ")"; //make the string literal a subpattern
	p->setRegExp(regexp);
	patternListHandler.add(p);
}

void patternDefinition(Pattern myP)
{
	Pattern p;
	p = myP;
	
	//traverse the subpattern list and resolve all references to already defined patterns
	vector<Pattern>::iterator itr1,itr2;
	vector<Pattern> patternList = p.getPatternList();
	for( itr1 = patternList.begin() ; itr1 != patternList.end() ; ++itr1 )
	{
		vector<Pattern> patternList2 = (*itr1).getPatternList();
		for( itr2 = patternList2.begin() ; itr2 != patternList2.end() ; ++itr2 )
		{
			string patternRef = (*itr2).getVarName();
			//if name is set, then it must be a reference
			if( patternRef.size() > 0 )
			{
				if( true == symbtable.lookup(patternRef) )
				{
					//if found, make a copy of it
					Pattern* tmp = patternListHandler.findByName(patternRef);
					(*itr2) = (*tmp);
				}
				else
				{
					lg->printMsg("In patternDefinition",(int)TML_SYNTAX_ERROR_INVALID_VALUE);
				}
			}
		}
	
		(*itr1).setPatternList(patternList2);
	}

	p.setPatternList(patternList);
	p.printPatternList();	

	string msg = p.concatPatternList();
	lg->printMsg("Concatenated pattern = ",0);
	
	Pattern* pNew = new Pattern();
	(*pNew) = p;
	
	string pName = p.getVarName();
	//if this pattern has already been defined, redefine it
	if( patternListHandler.findByName(pName) != NULL )
		patternListHandler.remove(pName);
	patternListHandler.add(pNew);
}

/*
 * when setting one search to another
 * Just make another copy of it
 */
void searchDefinition(string lval, string rval,char* optionValue)
{
	if( true == symbtable.lookup(lval) )
	{
		if( symbtable.findValueByKey(lval).compare("search") == 0 )
		{
			Search* sch;
			bool isNew=false;
			//check search_list to make sure an object for this does not already exists
			if( (sch = searchListHandler.findByName(lval)) == NULL )
			{
				isNew = true;
				sch = new Search;
				sch->setVarName(lval);
				sch->setDefaults();
			}
			//check to see if rval is a reference
			//if so, check to see if type matches
			
			//otherwise, set option flag
			
			string s(optionValue);
			if( s.compare("input") == 0 )
			{
				InputFile* in = inputFileListHandler.findByName(rval);
				sch->setInput(in);
			}
			else if( s.compare("pattern") == 0 )
			{
				if( symbtable.findValueByKey(rval).compare("pattern") == 0 )
				{
					Pattern* p;
					p = patternListHandler.findByName(rval);
					sch->setPattern(p);
				}
				else
				{
					//Error: this pattern variable is not in Symbol Table
					lg->printMsg("In searchDefinition ",(int)TML_SYNTAX_ERROR_INVALID_VALUE);
				}
			}
			else if( s.compare("action") == 0 )
			{
				if( rval.compare("replace") == 0 )
					sch->setSearchAction(REPLACE);
				else
				{
					//Error
					lg->printMsg("In searchDefinition ",(int)TML_SYNTAX_ERROR_INVALID_VALUE);
				}
			}
			else if( s.compare("replace") == 0 )
			{
				sch->setReplaceString(rval);
			}
			//else if( s.compare("type") == 0 )
			//{
			//}
			else if( s.compare("mode") == 0 )
			{
				if( rval.compare("case") == 0 )
				{
					sch->setCase(true);
				}
				else if( rval.compare("nocase") == 0 )
				{
					sch->setCase(false);
				}
				else if( rval.compare("beginsWith") == 0 )
				{
					sch->setBeginsWith(true);
				}
				else if( rval.compare("endsWith") == 0 )
				{
					sch->setEndsWith(true);
				}
				else if( rval.compare("reset") == 0 )
				{
					sch->setResetMode(true);
				}
				else 
				{
					//error, invalid rvalue
					lg->printMsg("In searchDefinition ",(int)TML_SYNTAX_ERROR_INVALID_VALUE);
				}
				
			}
			else //Error!
			{
				lg->printMsg("In searchDefinition ",(int)TML_SYNTAX_ERROR_INVALID_VALUE);
			}
			
			if( isNew )
				searchListHandler.add(sch);
			
		}
		else
		{
			//wrong type, error
			lg->printMsg("In searchDefinition ",(int)TML_SYNTAX_ERROR_INVALID_VALUE);
		}
	}
	else
	{
		//error
		lg->printMsg("In searchDefinition ",(int)TML_SYNTAX_ERROR_INVALID_VALUE);
	}
	
}

/*
 * Verified that the pattern id being used on the right side
 * of a pattern definition has already been defined
 */
void verifyPatternID(string pName)
{
	if( patternListHandler.findByName(pName) == NULL )
	{
		lg->printMsg("Error: undefined pattern identifier",(int)TML_SYNTAX_ERROR_INVALID_VALUE);
		lg->printMsg(pName,0);
		exit(0);
	}
}

/*
 * Resolve the reference by making a copy
 */
void resolveID(Pattern* p)
{
	Pattern* tmp = patternListHandler.findByName(p->getVarName());
	(*p) = (*tmp);
}

void executeSearch(string s)
{
	Search* sch;
	int ret=0;
	sch = searchListHandler.findByName(s);
	ret = sch->performSearch();
}
