#!/bin/csh
set TEST_DIR="test"

set GREEN=""
set RED=""
set FAIL_OPTS=""
set OPTIONS=""
while ( ${#argv} > 0 && ! $?ARGSDONE )
	switch ( "$1" )
      # use -nc option to turn of colorization
		case "-nc"
			set GREEN=""
			set RED=""
			shift
			breaksw
		case "-c"
         set GREEN="\033[32m"
         set RED="\033[31m"
			shift
			breaksw
		default
		   set ext=`echo $1 | cut -d. -f2`
		   if ( "$ext" == "s2d" ) then
			   set TEST=`echo $1 | cut -d. -f1`
         else
			   set OPTIONS="$OPTIONS $1"
			endif
			shift
			breaksw
	endsw
end

set ENDCOLOR="\033[00m"

java sim2d ${OPTIONS} $TEST_DIR/${TEST}.s2d > $TEST_DIR/${TEST}.out
diff $TEST_DIR/${TEST}.gold $TEST_DIR/${TEST}.out
if ( "$status" != "0" ) then
   echo ${TEST} " \t${RED}FAILED${ENDCOLOR}"
   if ( "$FAIL_OPTS" != "" ) then
      java sim2d $FAIL_OPTS < $TEST_DIR/${TEST}.s2d
  	endif
else
   echo ${TEST} " \t${GREEN}PASSED${ENDCOLOR}"
endif
