import java.util.LinkedHashMap;
import java.io.PrintWriter;
import antlr.collections.AST;

class Sim2ddistance_to extends Sim2dFunction {

    public Sim2ddistance_to( String inname ) {
		  super(inname);
    }

    public String typename() {
        return "distance_to";
    }

	 public Sim2dDataType execute(Sim2dSymbolTable symt, Sim2dDataType[] args) {
		  log.out("Executing function " + typename());
		  if (args.length != 1) {
	   	  throw new Sim2dException("function distance_to was passed " 
					  + args.length + " arguments, but only accepts 1");
		  }
		  if (!(args[0] instanceof Sim2dObject)) {
	   	  throw new Sim2dException("first argument to distance_to is not an object");
		  }
		  // The local object x and y symbols should be on top of symbol
		  // table stack
		  Sim2dFloat x1 = (Sim2dFloat)symt.get("x");
		  Sim2dFloat y1 = (Sim2dFloat)symt.get("y");

		  // The other object is passed as argument.  Get it's x and y
		  Sim2dObject to = (Sim2dObject)args[0];
		  Sim2dFloat x2 = (Sim2dFloat)to.getField("x");
		  Sim2dFloat y2 = (Sim2dFloat)to.getField("y");
		  return new Sim2dFloat(
				  (float)Math.pow( Math.pow(y2.var - y1.var, 2.0) +
				                   Math.pow(x2.var - x1.var, 2.0), 0.5));
	 }

}
