import java.util.LinkedHashMap;
import java.io.PrintWriter;
import antlr.collections.AST;

class Sim2dbearing_to extends Sim2dFunction {

    public Sim2dbearing_to( String inname ) {
		  super(inname);
    }

    public String typename() {
        return "bearing_to";
    }

	 public Sim2dDataType execute(Sim2dSymbolTable symt, Sim2dDataType[] args) {
		  log.out("Executing function " + typename());
		  if (args.length != 1) {
	   	  throw new Sim2dException("function bearing_to was passed " 
					  + args.length + " arguments, but only accepts 1");
		  }
		  if (!(args[0] instanceof Sim2dObject)) {
	   	  throw new Sim2dException("first argument to distance_to is not an object");
		  }
		  // The local object x and y symbols should be on top of symbol
		  // table stack
		  Sim2dFloat x1 = (Sim2dFloat)symt.get("x");
		  Sim2dFloat y1 = (Sim2dFloat)symt.get("y");

		  // The other object is passed as argument.  Get it's x and y
		  Sim2dObject to = (Sim2dObject)args[0];
		  Sim2dFloat x2 = (Sim2dFloat)to.getField("x");
		  Sim2dFloat y2 = (Sim2dFloat)to.getField("y");
		  float ang = (float)Math.toDegrees(Math.atan2( x2.var - x1.var, 
						                                    y1.var - y2.var));
		  if (ang > 360.0) {
			  ang -= 360.0;
		  } else if (ang < 0.0) {
			  ang += 360.0;
		  }

		  return new Sim2dFloat(ang);
	 }

}
