class Sim2darccos extends Sim2dFunction {

    public Sim2darccos( String inname ) {
		  super(inname);
    }

    public String typename() {
        return "arccos";
    }

	 public Sim2dDataType execute(Sim2dSymbolTable symt, Sim2dDataType[] args) {
		  log.out("Executing function " + typename());
		  if (args.length != 1) {
	   	  throw new Sim2dException("function " + typename() + " was passed " 
					  + args.length + " arguments, but only accepts 1");
		  }
		  float input;
		  if (args[0] instanceof Sim2dInt) {
				input = (float)((Sim2dInt)args[0]).var;
     	  } else if (args[0] instanceof Sim2dFloat) {
				input = ((Sim2dFloat)args[0]).var;
	     } else {
			   throw new Sim2dException("Invalid type '" + args[0].typename()
						+ "' passed to function " + typename());
		  }

		  return new Sim2dFloat((float)Math.toDegrees(Math.acos(input)));
	 }

}
