import java.util.LinkedHashMap;
import java.io.PrintWriter;
import antlr.collections.AST;

class Sim2dUserFunction extends Sim2dFunction {
    AST body;
	 sim2dWalker walker;
	 String [] argaliases;

    public Sim2dUserFunction( sim2dWalker inwalker, String inname, 
			                     String[] inargs, AST inbody) {
		  super(inname);
		  body = inbody;
		  walker = inwalker;
		  if (inargs == null)
			  log.out("inargs null");

		  argaliases = inargs;
    }

    public String typename() {
        return "function";
    }

    public AST getBody() {
        return body;
    }

	 public Sim2dDataType execute(Sim2dSymbolTable symt, Sim2dDataType[] args)
     throws antlr.RecognitionException	{
		  log.out("in " + this + " calling walker");
		  if (walker == null)
			  log.out("its null");
		  String[] oldnames = new String[args.length];
		  if (oldnames == null)
			  log.out("oldnames null");
		  if (argaliases == null)
			  log.out("argaliases null");
        log.out("oldnames.length = " + oldnames.length +
				    "argaliases.length = " + argaliases.length);
		  int i = 0;
		  for (Sim2dDataType arg : args) {
			  oldnames[i] = arg.getName();
			  log.out("setname " + arg.getName() + " to " + argaliases[i]);
			  arg.setName(argaliases[i]);
			  i++;
			  symt.put(arg);
		  }
		  Sim2dDataType ret = walker.expr(getBody());
		  i = 0;
		  for (Sim2dDataType arg : args) {
			  log.out("setname " + arg.getName() + " back to " + oldnames[i]);
			  arg.setName(oldnames[i++]);
		  }
		  return ret;
	 }

	 public String toString() {
		 String str = typename() + " " + name;
		 return str;
	 }
}
