import java.util.LinkedList;
import java.io.PrintWriter;

class Sim2dSymbolTable extends LinkedList <Sim2dDataType> {
    Sim2dSymbolTable parent;
    boolean read_only;
    int indent = 0;

    public Sim2dSymbolTable( Sim2dSymbolTable nparent ) {
       parent = nparent;
       read_only = false;
    }

	 public Sim2dDataType get(String name) {
		 for (Sim2dDataType symbol : this) {
			 if (symbol.getName().equals(name)) {
				 return symbol;
			 }
		 }
		 if (parent != null) {
			 return parent.get(name);
		 }
		 return null;
	 }

	 public boolean put(Sim2dDataType data) {
		 return add(data);
	 }

	 public boolean enterScope() {
		 return true;
	 }

	 public boolean leaveScope() {
		 return true;
	 }

	 public void Dump() {
	    log.out("Symbol Table Dump:");
		 Dump(this);
	 }
	 public void Dump(Sim2dSymbolTable scope) {
		 if (scope == null) {
			 return;
		 }
		 indent--;
		 Dump(scope.parent);
       indent++;
		 for ( Sim2dDataType symbol : scope) {
			 for (int i=0; i<indent; i++) {
			    System.out.print("   ");
			 }

			 if (!(symbol instanceof Sim2dFunction)) {
	  		    System.out.println(symbol);
			 }
		 }
	 }
}
