import java.util.LinkedHashMap;
import java.io.PrintWriter;

class Sim2dObject extends Sim2dDataType {
	 public LinkedHashMap<String, Sim2dDataType> fields;

    public Sim2dObject( String name ) {
		  super(name);
        fields = new LinkedHashMap<String, Sim2dDataType>();
    }

    public String typename() {
        return "object";
    }

    public void print( PrintWriter w ) {
        if ( name != null )
            w.print( name + " = " );
    }

	 public void put(Sim2dDataType data) {
		 log.out("Adding field to object " + name + " field is " + data.name);
		 if (fields.containsKey(data.name)) {
			 System.out.println("Error:  object " + name + " has multiple declarations of the field " + data.name);
			 System.exit(1);
		 }
		 fields.put(data.name, data);
	 }

	 public String toString() {
		 String str = typename() + " " + name + "(" + fields.size() + ") {";
		 boolean first = true;
		 for (String f : fields.keySet()) {
			 if (!first) {
			    str += ",";
			 }
			 str += " " + getField(f).toString();
			 first = false;
		 }
		 str += "}";
		 return str;
	 }

	 public Sim2dDataType getField(String name) {
		 return fields.get(name);
	 }

	 public void putIfAbsent(Sim2dDataType newfield) {
		 if (!fields.containsKey(newfield.name)) {
			 put(newfield);
		 } 
	 }

	 public void putIfAbsent(Sim2dFloat newfield) {
		 if (fields.containsKey(newfield.name)) {
			 Sim2dDataType f = fields.get(newfield.name);
			 if (f instanceof Sim2dInt) {
				 fields.remove(f.name);
				 newfield.var = ((Sim2dInt)f).var;
			 }
		 }
		 put(newfield);
	 }

	 public void putInternalFields() {
		 putIfAbsent(new Sim2dFloat("x", 0));
		 putIfAbsent(new Sim2dFloat("y", 0));
		 putIfAbsent(new Sim2dFloat("heading", 0));
		 putIfAbsent(new Sim2dFloat("speed", 0));
		 putIfAbsent(new Sim2dBool("visible", true));
	 }
}
