import java.io.PrintWriter;

class Sim2dInt extends Sim2dDataType {
    int var;

    public Sim2dInt( int x ) {
        var = x; 
    }

    public Sim2dDataType assign( Sim2dDataType rvalue ) { 
		 if (rvalue instanceof Sim2dInt)
			 var = ((Sim2dInt)rvalue).var;
		 else
			 throw new Sim2dException("Incompatible types in"
					 + " assignment, " + typename() + " <- " 
					 + rvalue.typename());
		 return this;
	 }

    public Sim2dDataType assign( Sim2dInt rvalue ) { 
		 var = rvalue.var;
		 return this;
	 }

    public Sim2dInt( String name, int x ) {
		  super(name);
        var = x;
    }

    public String typename() {
        return "int";
    }

    public Sim2dDataType copy() {
        return new Sim2dInt( name, var );
    }

    public static int intValue( Sim2dDataType b ) {
        if ( b instanceof Sim2dInt )
            return ((Sim2dInt)b).var;
        b.error( "cast to int" );
        return 0;
    }

    public void print( PrintWriter w ) {
        if ( name != null )
            w.print( name + " = " );
        w.println( Integer.toString( var ) );
    }

    public Sim2dDataType uminus() {
        return new Sim2dInt( -var );
    }

    public Sim2dDataType plus( Sim2dDataType b ) {
        return new Sim2dInt( var + intValue(b) );
    }

    public Sim2dDataType add( Sim2dDataType b ) {
        var += intValue( b );
        return this;
    }

    public Sim2dDataType minus( Sim2dDataType b ) {
        return new Sim2dInt( var - intValue(b) );
    }
    
    public Sim2dDataType subtract( Sim2dDataType b ) {
        var -= intValue( b );
        return this;
    }

    public Sim2dDataType times( Sim2dDataType b ) {
        return new Sim2dInt( var * intValue(b) );
    }

    public Sim2dDataType multiply( Sim2dDataType b ) {
        return new Sim2dInt( var * intValue(b) );
    }

    public Sim2dDataType lfracts( Sim2dDataType b ) {
        return new Sim2dInt( var / intValue(b) );
    }

    public Sim2dDataType rfracts( Sim2dDataType b ) {
        return lfracts( b );
    }

    public Sim2dDataType ldiv( Sim2dDataType b ) {
        var /= intValue(b);
        return this;
    }

    public Sim2dDataType rdiv( Sim2dDataType b ) {
        return ldiv( b );
    }

    public Sim2dDataType modulus( Sim2dDataType b ) {
        return new Sim2dInt( var % intValue(b) );
    }


    public Sim2dDataType rem( Sim2dDataType b ) {
        var %= intValue( b );
        return this;
    }

    public Sim2dDataType gt( Sim2dDataType b ) {
        if ( b instanceof Sim2dInt )
            return new Sim2dBool( var > intValue(b) );
        return b.lt( this );
    }

    public Sim2dDataType gteq( Sim2dDataType b ) {
        if ( b instanceof Sim2dInt )
            return new Sim2dBool( var >= intValue(b) );
        return b.lteq( this );
    }

    public Sim2dDataType lt( Sim2dDataType b ) {
        if ( b instanceof Sim2dInt )
            return new Sim2dBool( var < intValue(b) );
        return b.gt( this );
    }

    public Sim2dDataType lteq( Sim2dDataType b ) {
        if ( b instanceof Sim2dInt )
            return new Sim2dBool( var <= intValue(b) );
        return b.gteq( this );
    }

    public Sim2dDataType eq( Sim2dDataType b ) {
        if ( b instanceof Sim2dInt )
            return new Sim2dBool( var == intValue(b) );
        return b.eq( this );
    }

    public Sim2dDataType neq( Sim2dDataType b ) {
        if ( b instanceof Sim2dInt )
            return new Sim2dBool( var != intValue(b) );
        return b.neq( this );
    }    

	 public String toString() {
		  return typename() + " " + name + "=" + var;
	 }
}
