import java.io.PrintWriter;

class Sim2dFloat extends Sim2dDataType {
    float var;

    public Sim2dFloat( float x ) {
        var = x;
    }

    public Sim2dDataType assign( Sim2dDataType rvalue ) { 
		 if (rvalue instanceof Sim2dFloat)
			 var = ((Sim2dFloat)rvalue).var;
		 else
			 throw new Sim2dException("Incompatible types in"
					 + " assignment, " + typename() + " <- " 
					 + rvalue.typename());
		 return this;
	 }

    public Sim2dDataType assign( Sim2dFloat rvalue ) { 
		 var = rvalue.var;
		 return this;
	 }

    public Sim2dFloat( String name, float x ) {
		  super(name);
        var = x;
    }

    public String typename() {
        return "float";
    }

    public Sim2dDataType copy() {
        return new Sim2dFloat( name, var );
    }

    public static float floatValue( Sim2dDataType b ) {
        if ( b instanceof Sim2dFloat )
            return ((Sim2dFloat)b).var;
        b.error( "cast to float" );
        return 0;
    }

    public void print( PrintWriter w ) {
        if ( name != null )
            w.print( name + " = " );
        w.println( Float.toString( var ) );
    }

    public Sim2dDataType uminus() {
        return new Sim2dFloat( -var );
    }

    public Sim2dDataType plus( Sim2dDataType b ) {
        return new Sim2dFloat( var + floatValue(b) );
    }

    public Sim2dDataType add( Sim2dDataType b ) {
        var += floatValue( b );
        return this;
    }

    public Sim2dDataType minus( Sim2dDataType b ) {
        return new Sim2dFloat( var - floatValue(b) );
    }
    
    public Sim2dDataType subtract( Sim2dDataType b ) {
        var -= floatValue( b );
        return this;
    }

    public Sim2dDataType times( Sim2dDataType b ) {
        return new Sim2dFloat( var * floatValue(b) );
    }

    public Sim2dDataType multiply( Sim2dDataType b ) {
        return new Sim2dFloat( var * floatValue(b) );
    }

    public Sim2dDataType lfracts( Sim2dDataType b ) {
        return new Sim2dFloat( var / floatValue(b) );
    }

    public Sim2dDataType rfracts( Sim2dDataType b ) {
        return lfracts( b );
    }

    public Sim2dDataType ldiv( Sim2dDataType b ) {
        var /= floatValue(b);
        return this;
    }

    public Sim2dDataType rdiv( Sim2dDataType b ) {
        return ldiv( b );
    }

    public Sim2dDataType modulus( Sim2dDataType b ) {
        return new Sim2dFloat( var % floatValue(b) );
    }


    public Sim2dDataType rem( Sim2dDataType b ) {
        var %= floatValue( b );
        return this;
    }

    public Sim2dDataType gt( Sim2dDataType b ) {
        if ( b instanceof Sim2dFloat )
            return new Sim2dBool( var > floatValue(b) );
        if ( b instanceof Sim2dInt )
            return new Sim2dBool( var > (float)(Sim2dInt.intValue(b)) );
        return b.lt( this );
    }

    public Sim2dDataType gteq( Sim2dDataType b ) {
        if ( b instanceof Sim2dFloat )
            return new Sim2dBool( var >= floatValue(b) );
        if ( b instanceof Sim2dInt )
            return new Sim2dBool( var >= (float)(Sim2dInt.intValue(b)) );
        return b.lteq( this );
    }

    public Sim2dDataType lt( Sim2dDataType b ) {
        if ( b instanceof Sim2dFloat )
            return new Sim2dBool( var < floatValue(b) );
        if ( b instanceof Sim2dInt )
            return new Sim2dBool( var < (float)(Sim2dInt.intValue(b)) );
        return b.gt( this );
    }

    public Sim2dDataType lteq( Sim2dDataType b ) {
        if ( b instanceof Sim2dFloat )
            return new Sim2dBool( var <= floatValue(b) );
        if ( b instanceof Sim2dInt )
            return new Sim2dBool( var <= (float)(Sim2dInt.intValue(b)) );
        return b.gteq( this );
    }

    public Sim2dDataType eq( Sim2dDataType b ) {
        if ( b instanceof Sim2dFloat )
            return new Sim2dBool( var == floatValue(b) );
        return b.eq( this );
    }

    public Sim2dDataType neq( Sim2dDataType b ) {
        if ( b instanceof Sim2dFloat )
            return new Sim2dBool( var != floatValue(b) );
        return b.neq( this );
    }    

	 public String toString() {
		  return typename() + " " + name + "=" + var;
	 }
}
