public class Sim2dDataType
{
	String name;

	public Sim2dDataType() {
		name = null;
	}

   public Sim2dDataType copy() {
      return new Sim2dDataType( name );
   }


	public Sim2dDataType( String name ) {
		setName(name);
	}

	public void setName( String name ) {
		this.name = name;
	}

	public String getName( ) {
		return name;
	}

	public Sim2dDataType multiply(Sim2dDataType b) {
      return error( b, "+" ); 
	}

	public Sim2dDataType error( String msg ) {
		System.out.println( "illegal operation: " + msg 
				+ "( <" + typename() + "> "
				+ ( name != null ? name : "<?>" )
				+ " )" );
		return null;
	}

	public String typename() {
		return "unknown";
	}

	public Sim2dDataType error( Sim2dDataType b, String msg ) {
		if ( null == b )
			return error( msg );
		System.out.println( "illegal operation: " + msg
				+ "( <" + typename() + "> "
				+ ( name != null ? name : "<?>" )
				+ " and " 
				+ "<" + typename() + "> "
				+ ( name != null ? name : "<?>" )
				+ " )" );
		return null;
	}

    public Sim2dDataType assign( Sim2dInt rvalue ) { 
        return error( rvalue, "<-" ); 
    }
    public Sim2dDataType assign( Sim2dDataType rvalue ) { 
        return error( rvalue, "<-" ); 
    }

    public Sim2dDataType transpose() {
        return error( "\'" );
    }

    public Sim2dDataType uminus() { 
        return error( "-" ); 
    }

    public Sim2dDataType plus( Sim2dDataType b ) { 
        return error( b, "+" ); 
    }

    public Sim2dDataType add( Sim2dDataType b ) { 
        return error( b, "+=" ); 
    }

    public Sim2dDataType minus( Sim2dDataType b ) { 
        return error( b, "-" ); 
    }
    
    public Sim2dDataType subtract( Sim2dDataType b ) { 
        return error( b, "-=" ); 
    }

    public Sim2dDataType times( Sim2dDataType b ) { 
        return error( b, "*" ); 
    }

    public Sim2dDataType mul( Sim2dDataType b ) { 
        return error( b, "*=" ); 
    }

    public Sim2dDataType lfracts( Sim2dDataType b ) { 
        return error( b, "/" ); 
    }

    public Sim2dDataType rfracts( Sim2dDataType b ) { 
        return error( b, "/\'" ); 
    }

    public Sim2dDataType ldiv( Sim2dDataType b ) { 
        return error( b, "/=" ); 
    }

    public Sim2dDataType rdiv( Sim2dDataType b ) { 
        return error( b, "/\'=" ); 
    }

    public Sim2dDataType modulus( Sim2dDataType b ) {
        return error( b, "%" );
    }

    public Sim2dDataType rem( Sim2dDataType b ) {
        return error( b, "%=" );
    }

    public Sim2dDataType gt( Sim2dDataType b ) { 
        return error( b, ">" ); 
    }

    public Sim2dDataType gteq( Sim2dDataType b ) { 
        return error( b, ">=" ); 
    }

    public Sim2dDataType lt( Sim2dDataType b ) { 
        return error( b, "<" ); 
    }

    public Sim2dDataType lteq( Sim2dDataType b ) { 
        return error( b, "<=" ); 
    }

    public Sim2dDataType eq( Sim2dDataType b ) { 
        return error( b, "==" ); 
    }

    public Sim2dDataType neq( Sim2dDataType b ) { 
        return error( b, "!=" ); 
    }

    public Sim2dDataType and( Sim2dDataType b ) { 
        return error( b, "and" ); 
    }
    
    public Sim2dDataType or( Sim2dDataType b ) { 
        return error( b, "or" ); 
    }

    public Sim2dDataType not() { 
        return error( "not" ); 
    }

	 public String toString() {
		  return typename() + " " + name;
	 }

}

