import java.io.PrintWriter;

class Sim2dBool extends Sim2dDataType {
    boolean var;

    Sim2dBool( boolean var ) {
        this.var = var;
    }

    public Sim2dBool( String name, boolean x ) {
		  super(name);
        var = x;
    }


    public String typename() {
        return "bool";
    }

    public Sim2dDataType copy() {
        return new Sim2dBool( var );
    }

    public Sim2dDataType assign( Sim2dDataType rvalue ) { 
		 log.out("bool assign");
		 if (rvalue instanceof Sim2dBool)
			 var = ((Sim2dBool)rvalue).var;
		 else
			 throw new Sim2dException("Incompatible types in"
					 + " assignment, " + typename() + " <- " 
					 + rvalue.typename());
		 return this;
	 }


    public void print( PrintWriter w ) {
        if ( name != null )
            w.print( name + " = " );
        w.println( var ? "true" : "false" );
    }


    public Sim2dDataType and( Sim2dDataType b ) {
        if ( b instanceof Sim2dBool )
            return new Sim2dBool( var && ((Sim2dBool)b).var );
        return error( b, "and" );
    }

    public Sim2dDataType or( Sim2dDataType b ) {
        if ( b instanceof Sim2dBool )
            return new Sim2dBool( var || ((Sim2dBool)b).var );
        return error( b, "or" );
    }

    public Sim2dDataType not() {
        return new Sim2dBool( !var );
    }

    public Sim2dDataType eq( Sim2dDataType b ) {
        if ( b instanceof Sim2dBool )
            return new Sim2dBool( ( var && ((Sim2dBool)b).var ) 
                               || ( !var && !((Sim2dBool)b).var ) );
        return error( b, "==" );
    }

    public Sim2dDataType neq( Sim2dDataType b ) {
        if ( b instanceof Sim2dBool )
            return new Sim2dBool( ( var && !((Sim2dBool)b).var ) 
                               || ( !var && ((Sim2dBool)b).var ) );
        return error( b, "!=" );
    }
	 public String toString() {
		  return typename() + " " + name + "=" + var;
	 }
}
