/*
 * Decompiled with CFR 0.152.
 */
import antlr.CommonAST;
import antlr.RecognitionException;
import antlr.TokenStreamException;
import antlr.collections.AST;
import antlr.debug.misc.ASTFrame;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;

class sim2d {
    Display display = null;
    boolean graphical_ast = false;
    boolean text_ast = false;
    boolean skip_simulation = false;
    boolean dump_symbol_table = false;
    boolean suppress_display = false;
    int iteration_delay = 250;
    int quit_count = -1;
    String src_file = "";

    private static void dumpAST(AST aST, int n) {
        if (aST != null) {
            for (int i = 0; i < n; ++i) {
                System.out.print("   ");
            }
            System.out.println(aST.getText());
            sim2d.dumpAST(aST.getFirstChild(), n + 1);
            sim2d.dumpAST(aST.getNextSibling(), n);
        }
    }

    public static void main(String[] stringArray) {
        sim2d sim2d2 = new sim2d(stringArray);
    }

    public sim2d(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-g")) {
                this.graphical_ast = true;
                continue;
            }
            if (stringArray[i].equals("-t")) {
                this.text_ast = true;
                continue;
            }
            if (stringArray[i].equals("-s")) {
                this.suppress_display = true;
                continue;
            }
            if (stringArray[i].equals("-v")) {
                log.on();
                continue;
            }
            if (stringArray[i].equals("-r")) {
                this.iteration_delay = new Integer(stringArray[++i]);
                continue;
            }
            if (stringArray[i].equals("-i")) {
                this.quit_count = new Integer(stringArray[++i]);
                continue;
            }
            if (stringArray[i].equals("-d")) {
                this.dump_symbol_table = true;
                continue;
            }
            if (stringArray[i].equals("-h") || stringArray[i].equals("--help") || stringArray[i].equals("-help")) {
                System.out.println("Sim2d options:\n   -h            This message\n   -s            Suppress map display\n   -i [number]   Quit after [number] iterations\n   -r [delay]    Time delay between iterations in msecs\n   -g            Show graphical AST\n   -t            Show textual AST\n   -d            Dump symbol table after each iteration\n   -v            Output verbose debugging text\n");
                System.exit(0);
                continue;
            }
            this.src_file = stringArray[i];
        }
        try {
            sim2dWalker sim2dWalker2;
            FileInputStream fileInputStream = new FileInputStream(this.src_file);
            DataInputStream dataInputStream = new DataInputStream(fileInputStream);
            sim2dLexer sim2dLexer2 = new sim2dLexer(new DataInputStream(dataInputStream));
            sim2dLexer2.setFilename(this.src_file);
            sim2dParser sim2dParser2 = new sim2dParser(sim2dLexer2);
            sim2dParser2.setFilename(this.src_file);
            sim2dParser2.file();
            CommonAST commonAST = (CommonAST)sim2dParser2.getAST();
            if (this.text_ast) {
                System.out.println(commonAST.toStringList());
            }
            if (this.graphical_ast) {
                sim2dWalker2 = new ASTFrame("AST from the Sim2d parser", (AST)commonAST);
                sim2dWalker2.setVisible(true);
            }
            sim2dWalker2 = new sim2dWalker();
            Sim2dInterpreter sim2dInterpreter = Sim2dInterpreter.getInstance();
            sim2dInterpreter.setWalker(sim2dWalker2);
            sim2dWalker2.file((AST)commonAST);
            if (this.dump_symbol_table) {
                sim2dInterpreter.sym.Dump();
            }
            int n = 0;
            if (!this.suppress_display) {
                this.display = new Display(sim2dInterpreter.sym);
            }
            while (n != this.quit_count) {
                for (Sim2dDataType sim2dDataType : sim2dInterpreter.sym) {
                    if (!(sim2dDataType instanceof Sim2dObject)) continue;
                    try {
                        Thread.currentThread();
                        Thread.sleep(this.iteration_delay);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    log.out("Running rule " + sim2dDataType.getName());
                    sim2dInterpreter.runRule((Sim2dObject)sim2dDataType);
                    Sim2dObject sim2dObject = (Sim2dObject)sim2dDataType;
                    Sim2dFloat sim2dFloat = (Sim2dFloat)sim2dObject.getField("x");
                    Sim2dFloat sim2dFloat2 = (Sim2dFloat)sim2dObject.getField("y");
                    Sim2dFloat sim2dFloat3 = (Sim2dFloat)sim2dObject.getField("heading");
                    Sim2dFloat sim2dFloat4 = (Sim2dFloat)sim2dObject.getField("speed");
                    sim2dFloat.var = (float)((double)sim2dFloat.var + (double)sim2dFloat4.var * Math.sin(Math.toRadians(sim2dFloat3.var)));
                    sim2dFloat2.var = (float)((double)sim2dFloat2.var - (double)sim2dFloat4.var * Math.cos(Math.toRadians(sim2dFloat3.var)));
                }
                if (this.dump_symbol_table) {
                    sim2dInterpreter.sym.Dump();
                }
                if (!this.suppress_display) {
                    this.display.refresh();
                }
                if (this.quit_count <= 0) continue;
                ++n;
            }
            System.exit(0);
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("Error (file): " + fileNotFoundException.getMessage());
            System.exit(-1);
        }
        catch (TokenStreamException tokenStreamException) {
            System.err.println("Error (token): " + tokenStreamException.getMessage());
        }
        catch (RecognitionException recognitionException) {
            System.err.println("Error (recog): " + recognitionException.getMessage());
        }
        catch (Exception exception) {
            System.err.println("Error (excep): " + exception);
            exception.printStackTrace();
        }
    }
}

