/*
 * Decompiled with CFR 0.152.
 */
import java.io.PrintWriter;

class Sim2dInt
extends Sim2dDataType {
    int var;

    public Sim2dInt(int n) {
        this.var = n;
    }

    @Override
    public Sim2dDataType assign(Sim2dDataType sim2dDataType) {
        if (!(sim2dDataType instanceof Sim2dInt)) {
            throw new Sim2dException("Incompatible types in assignment, " + this.typename() + " <- " + sim2dDataType.typename());
        }
        this.var = ((Sim2dInt)sim2dDataType).var;
        return this;
    }

    @Override
    public Sim2dDataType assign(Sim2dInt sim2dInt) {
        this.var = sim2dInt.var;
        return this;
    }

    public Sim2dInt(String string, int n) {
        super(string);
        this.var = n;
    }

    @Override
    public String typename() {
        return "int";
    }

    @Override
    public Sim2dDataType copy() {
        return new Sim2dInt(this.name, this.var);
    }

    public static int intValue(Sim2dDataType sim2dDataType) {
        if (sim2dDataType instanceof Sim2dInt) {
            return ((Sim2dInt)sim2dDataType).var;
        }
        sim2dDataType.error("cast to int");
        return 0;
    }

    public void print(PrintWriter printWriter) {
        if (this.name != null) {
            printWriter.print(this.name + " = ");
        }
        printWriter.println(Integer.toString(this.var));
    }

    @Override
    public Sim2dDataType uminus() {
        return new Sim2dInt(-this.var);
    }

    @Override
    public Sim2dDataType plus(Sim2dDataType sim2dDataType) {
        return new Sim2dInt(this.var + Sim2dInt.intValue(sim2dDataType));
    }

    @Override
    public Sim2dDataType add(Sim2dDataType sim2dDataType) {
        this.var += Sim2dInt.intValue(sim2dDataType);
        return this;
    }

    @Override
    public Sim2dDataType minus(Sim2dDataType sim2dDataType) {
        return new Sim2dInt(this.var - Sim2dInt.intValue(sim2dDataType));
    }

    @Override
    public Sim2dDataType subtract(Sim2dDataType sim2dDataType) {
        this.var -= Sim2dInt.intValue(sim2dDataType);
        return this;
    }

    @Override
    public Sim2dDataType times(Sim2dDataType sim2dDataType) {
        return new Sim2dInt(this.var * Sim2dInt.intValue(sim2dDataType));
    }

    @Override
    public Sim2dDataType multiply(Sim2dDataType sim2dDataType) {
        return new Sim2dInt(this.var * Sim2dInt.intValue(sim2dDataType));
    }

    @Override
    public Sim2dDataType lfracts(Sim2dDataType sim2dDataType) {
        return new Sim2dInt(this.var / Sim2dInt.intValue(sim2dDataType));
    }

    @Override
    public Sim2dDataType rfracts(Sim2dDataType sim2dDataType) {
        return this.lfracts(sim2dDataType);
    }

    @Override
    public Sim2dDataType ldiv(Sim2dDataType sim2dDataType) {
        this.var /= Sim2dInt.intValue(sim2dDataType);
        return this;
    }

    @Override
    public Sim2dDataType rdiv(Sim2dDataType sim2dDataType) {
        return this.ldiv(sim2dDataType);
    }

    @Override
    public Sim2dDataType modulus(Sim2dDataType sim2dDataType) {
        return new Sim2dInt(this.var % Sim2dInt.intValue(sim2dDataType));
    }

    @Override
    public Sim2dDataType rem(Sim2dDataType sim2dDataType) {
        this.var %= Sim2dInt.intValue(sim2dDataType);
        return this;
    }

    @Override
    public Sim2dDataType gt(Sim2dDataType sim2dDataType) {
        if (sim2dDataType instanceof Sim2dInt) {
            return new Sim2dBool(this.var > Sim2dInt.intValue(sim2dDataType));
        }
        return sim2dDataType.lt(this);
    }

    @Override
    public Sim2dDataType gteq(Sim2dDataType sim2dDataType) {
        if (sim2dDataType instanceof Sim2dInt) {
            return new Sim2dBool(this.var >= Sim2dInt.intValue(sim2dDataType));
        }
        return sim2dDataType.lteq(this);
    }

    @Override
    public Sim2dDataType lt(Sim2dDataType sim2dDataType) {
        if (sim2dDataType instanceof Sim2dInt) {
            return new Sim2dBool(this.var < Sim2dInt.intValue(sim2dDataType));
        }
        return sim2dDataType.gt(this);
    }

    @Override
    public Sim2dDataType lteq(Sim2dDataType sim2dDataType) {
        if (sim2dDataType instanceof Sim2dInt) {
            return new Sim2dBool(this.var <= Sim2dInt.intValue(sim2dDataType));
        }
        return sim2dDataType.gteq(this);
    }

    @Override
    public Sim2dDataType eq(Sim2dDataType sim2dDataType) {
        if (sim2dDataType instanceof Sim2dInt) {
            return new Sim2dBool(this.var == Sim2dInt.intValue(sim2dDataType));
        }
        return sim2dDataType.eq(this);
    }

    @Override
    public Sim2dDataType neq(Sim2dDataType sim2dDataType) {
        if (sim2dDataType instanceof Sim2dInt) {
            return new Sim2dBool(this.var != Sim2dInt.intValue(sim2dDataType));
        }
        return sim2dDataType.neq(this);
    }

    @Override
    public String toString() {
        return this.typename() + " " + this.name + "=" + this.var;
    }
}

