(*
 * This module deals with user input and output during interpretation.
 *)

(*
 * Get a string from the user.
 *)
let istring : string -> string =
  fun msg -> print_string msg; print_string " "; read_line ()

(*
 * Let the given player choose a string from a list of strings.
 * Return the paired item corresponding to the chosen string.
 *)
let rec lchoice : string -> (string * 'a) list -> 'a =
  fun msg -> function
    [] -> Utils.ie "Nothing to choose from"
  | choices ->
      print_endline msg;
      let show (s, _) = print_string "  "; print_endline s
      in List.iter show choices;
      let choice = istring "Your choice?" in
      let f (s, _) = choice = s in
      try snd (List.find f choices)
      with Not_found ->
        (print_endline "I'm sorry, I didn't understand.";
         lchoice msg choices)
 
(* Offer a choice of integers. *)
let ichoice : string -> int list -> int =
  fun msg il ->
    let f i = (string_of_int i, i) in
    let choices = List.map f il in
    lchoice msg choices

(* Show a message to all users *)
let show_all : string -> unit =
  print_endline

(* Show a message to the named player *)
let show : string -> string -> unit =
  fun player msg ->
    print_endline (player ^ ": " ^ msg)

