(**************)
(* The Driver *)

let usage_msg = "Usage: pip [ --print-ast | --analyze ] input_file"

(* Command-line options and setters for Arg.parse *)
let print_ast = ref false
let analyze = ref false
let input_file = ref ""

let set_print_ast () = print_ast := true
let set_analyze ()   = analyze := true
let set_input_file f = input_file := f

(* Main *)
let main () =
  let desc =
    [("--print-ast", Arg.Unit(set_print_ast), "Print the AST and exit.");
     ("--analyze",   Arg.Unit(set_analyze),   "Semantic analysis and exit.")]
  in
  Arg.parse desc set_input_file usage_msg;
  
  if !input_file = "" then (print_endline usage_msg; exit 1);

  (* Syntax *)
  let input = open_in !input_file in
  let lexbuf = Lexing.from_channel input in
  let ast = Parser.game Scanner.token lexbuf in
  close_in input;
  if !print_ast then (print_string (Ast.str_game ast); exit 0);
  
  (* Semantics *)
  let cast = Semantic.sem_game ast in
  if !analyze then exit 0;
  
  (* Interpretation *)
  Interp.run_game cast;
  exit 0

(* Run main *)
let _ = try main () with Failure(s) -> (print_endline s; exit 1)
