#
# Description:
#
#  This includable Makefile sets up project-wide settings. It should be
#  included after TOP is set by an invocable Makefile, but before anything
#  else is done.
#

# Basics
SHELL  = /bin/sh

.SUFFIXES:

# This is where binaries and temporary generated files live. These are removed
# during a "make clean".

BIN_DIR  := $(TOP)/bin
TEMP_DIR := $(TOP)/tmp
DOC_DIR  := $(TOP)/doc

# Tests live here

TEST_DIR := $(TOP)/tests

# Programs and Flags

CP     := cp
LEX    := ocamllex
YACC   := ocamlyacc
CC     := ocamlc -g
DEP    := ocamldep

FIXDEP  := $(TOP)/scripts/fixdep
TEXDEP  := $(TOP)/scripts/texdep
TESTIT  := $(TOP)/scripts/testit
SILENCE := $(TOP)/scripts/silence
OORDER  := $(TOP)/scripts/ocamlorder

DOT      := dot
PDFLATEX := pdflatex

# A quiet flag. Run "make Q=" for verbose.
Q := @

# Global settings used by other Makefiles

PSPDFS    :=
PDFS      :=
LEXFILES  :=
YACCFILES :=
OBJECTS   :=
DEPS      :=
TEXDEPS   :=
BINARIES  :=
