#
# Description:
#
#  This includable Makefile sets up the rules for building generic
#  targets from generic sources. It should be included at the bottom
#  of an invocable Makefile that needs the rules.
#

.PHONY: build
build: $(BINARIES)

.PHONY: pdfs
pdfs: $(PDFS)

$(PDFS):
	@# The pdf dependencies include more than just .tex
	@# files, but those are the only files we can pass
	@# on the command-line.
	$(Q)mkdir -p $(dir $@)
	$(Q)mkdir -p $(TEMP_DIR)/pdf
	@echo " PDF $(filter %.tex,$+) => $@"
	@# Run twice for table-of-contents generation
	$(Q)$(SILENCE) $(PDFLATEX) -halt-on-error -output-directory $(TEMP_DIR)/pdf $(filter %.tex,$+)
	$(Q)$(SILENCE) $(PDFLATEX) -halt-on-error -output-directory $(TEMP_DIR)/pdf $(filter %.tex,$+)
	$(Q)$(CP) $(TEMP_DIR)/pdf/$(notdir $@) $@

$(PSPDFS):
	$(Q)mkdir -p $(dir $@)
	@echo " DOT $<"
	$(Q)$(DOT) -Tpdf $< > $@

$(BINARIES):
	$(Q)mkdir -p $(dir $@)
	@echo "  OC $@"
	$(Q)$(CC) -o $@ $(shell $(OORDER) $+)

$(LEXFILES):
	$(Q)mkdir -p $(dir $@)
	@echo "  LX $<"
	$(Q)$(LEX) -q -o $@ $<

$(YACCFILES):
	$(Q)mkdir -p $(dir $@)
	@echo "  YC $<"
	$(Q)$(YACC) -b $(dir $@)/$(basename $(notdir $@)) $<

$(OBJECTS):
	@# The ocamldep dependencies add in more than just .ml and .mll
	@# files, but those are the only files we can pass on the command-line.
	$(Q)mkdir -p $(dir $@)
	$(Q)echo "  OC $(filter %.ml,$+) $(filter %.mli,$+)"
	$(Q)$(CC) -I $(dir $@) -c -o $@ $(filter %.ml,$+) $(filter %.mli,$+)

$(DEPS):
	$(Q)mkdir -p $(dir $@)
	@echo " DEP $<"
	$(Q)$(DEP) -I $(dir $<) -I $(dir $@) $< > $@
	$(Q)$(FIXDEP) $(TOP) $@ $(dir $<) $(dir $@)

$(TEXDEPS):
	$(Q)mkdir -p $(dir $@)
	@echo " DEP $<"
	$(Q)$(TEXDEP) $< $(DOC_DIR)/$(basename $(notdir $<)).pdf > $@
	$(Q)$(FIXDEP) $(TOP) $@

# Include any automatically-generated dependency information
ifneq "clean" "$(MAKECMDGOALS)"
-include $(DEPS)
-include $(TEXDEPS)
endif
