#
# Description:
#
#  This includable Makefile sets up a pdf in $(TOP)/tmp/<dir> to be created
#  for each *.tex in the current directory.
#
#  The current directory is given by the variable $(HERE).
#
#  The name of the pdf will be the same as the name of the tex file.
#

# $(HERE) and $(TOP) are set. Find the relative path from TOP to HERE
# and set it as $(REL_HERE).

# Make 3.81:
# ABS_TOP  := $(realpath $(TOP))
# ABS_HERE := $(realpath $(HERE))

# Make 3.80:
ABS_TOP  := $(shell cd "$(TOP)"; /bin/pwd)
ABS_HERE := $(shell cd "$(HERE)"; /bin/pwd)

REL_HERE := $(patsubst $(ABS_TOP)/%,%,$(ABS_HERE))

# Set up sources
MY_DOT   := $(wildcard $(HERE)/*.dot)
MY_TEX   := $(wildcard $(HERE)/*.tex)
MY_PSPDF := $(patsubst $(HERE)/%.dot,$(TEMP_DIR)/$(REL_HERE)/%.pdf,$(MY_DOT))
MY_DEPS  := $(patsubst $(HERE)/%.tex,$(TEMP_DIR)/$(REL_HERE)/%.pdf.d,$(MY_TEX))
MY_PDF   := $(patsubst $(HERE)/%.tex,$(DOC_DIR)/%.pdf,$(MY_TEX))

# These pass information to the global Make system (like rules.mk.inc)
PSPDFS  += $(MY_PSPDF)
PDFS    += $(MY_PDF)
TEXDEPS += $(MY_DEPS)

# These link the sources to the objects
$(MY_PSPDF): $(TEMP_DIR)/$(REL_HERE)/%.pdf: $(HERE)/%.dot
$(MY_DEPS):  $(TEMP_DIR)/$(REL_HERE)/%.pdf.d: $(HERE)/%.tex
$(MY_PDF):   $(DOC_DIR)/%.pdf: $(HERE)/%.tex
