#
# Description:
#
#  This includable Makefile sets up a binary in $(TOP)/bin to be created
#  from all of the *.ml, *.mli, *.mly, and *.mll files in the current directory.
#
#  The current directory is given by the variable $(HERE).
#
#  The name of the binary will be the same as the name of the directory
#  unless $(MY_BIN) is set to an absolute path. This Makefile unsets
#  $(MY_BIN) at the end.
#

# $(HERE) and $(TOP) are set. Find the relative path from TOP to HERE
# and set it as $(REL_HERE).

# Make 3.81:
# ABS_TOP  := $(realpath $(TOP))
# ABS_HERE := $(realpath $(HERE))

# Make 3.80:
ABS_TOP  := $(shell cd "$(TOP)"; /bin/pwd)
ABS_HERE := $(shell cd "$(HERE)"; /bin/pwd)

REL_HERE := $(patsubst $(ABS_TOP)/%,%,$(ABS_HERE))

# Set up sources and objects local to this directory
MY_ML_SRC := $(wildcard $(HERE)/*.ml)
MY_ML_OBJ := $(patsubst $(HERE)/%.ml,$(TEMP_DIR)/$(REL_HERE)/%.cmo,$(MY_ML_SRC))
MY_ML_DEP := $(patsubst $(HERE)/%.ml,$(TEMP_DIR)/$(REL_HERE)/%.cmo.d,$(MY_ML_SRC))

MY_MLI_SRC := $(wildcard $(HERE)/*.mli)
MY_MLI_OBJ := $(patsubst $(HERE)/%.mli,$(TEMP_DIR)/$(REL_HERE)/%.cmi,$(MY_MLI_SRC))
MY_MLI_DEP := $(patsubst $(HERE)/%.mli,$(TEMP_DIR)/$(REL_HERE)/%.cmi.d,$(MY_MLI_SRC))

MY_MLL_SRC := $(wildcard $(HERE)/*.mll)
MY_MLL_ML  := $(patsubst $(HERE)/%.mll,$(TEMP_DIR)/$(REL_HERE)/%.ml,$(MY_MLL_SRC))
MY_MLL_OBJ := $(patsubst $(TEMP_DIR)/$(REL_HERE)/%.ml,$(TEMP_DIR)/$(REL_HERE)/%.cmo,$(MY_MLL_ML))
MY_MLL_DEP := $(patsubst $(TEMP_DIR)/$(REL_HERE)/%.ml,$(TEMP_DIR)/$(REL_HERE)/%.cmo.d,$(MY_MLL_ML))

MY_MLY_SRC  := $(wildcard $(HERE)/*.mly)
MY_MLY_ML   := $(patsubst $(HERE)/%.mly,$(TEMP_DIR)/$(REL_HERE)/%.ml,$(MY_MLY_SRC))
MY_MLY_MLI  := $(patsubst $(HERE)/%.mly,$(TEMP_DIR)/$(REL_HERE)/%.mli,$(MY_MLY_SRC))
MY_MLY_OBJ  := $(patsubst $(TEMP_DIR)/$(REL_HERE)/%.ml,$(TEMP_DIR)/$(REL_HERE)/%.cmo,$(MY_MLY_ML))
MY_MLY_DEP  := $(patsubst $(TEMP_DIR)/$(REL_HERE)/%.ml,$(TEMP_DIR)/$(REL_HERE)/%.cmo.d,$(MY_MLY_ML))
MY_MLY_OBJI := $(patsubst $(TEMP_DIR)/$(REL_HERE)/%.mli,$(TEMP_DIR)/$(REL_HERE)/%.cmi,$(MY_MLY_MLI))
MY_MLY_DEPI := $(patsubst $(TEMP_DIR)/$(REL_HERE)/%.mli,$(TEMP_DIR)/$(REL_HERE)/%.cmi.d,$(MY_MLY_MLI))

MY_BIN := $(if $(MY_BIN),$(MY_BIN),$(BIN_DIR)/$(notdir $(ABS_HERE)))

# These pass information to the global Make system (like rules.mk.inc)
LEXFILES  += $(MY_MLL_ML)
YACCFILES += $(MY_MLY_ML)
OBJECTS   += $(MY_ML_OBJ) $(MY_MLI_OBJ) $(MY_MLL_OBJ) $(MY_MLY_OBJ) $(MY_MLY_OBJI)
DEPS      += $(MY_ML_DEP) $(MY_MLI_DEP) $(MY_MLL_DEP) $(MY_MLY_DEP) $(MY_MLY_DEPI)
BINARIES  += $(MY_BIN)

# These link the sources to the objects, and the objects to the binary
$(MY_ML_OBJ):  $(TEMP_DIR)/$(REL_HERE)/%.cmo:   $(HERE)/%.ml
$(MY_ML_DEP):  $(TEMP_DIR)/$(REL_HERE)/%.cmo.d: $(HERE)/%.ml

$(MY_MLI_OBJ): $(TEMP_DIR)/$(REL_HERE)/%.cmi:   $(HERE)/%.mli
$(MY_MLI_DEP): $(TEMP_DIR)/$(REL_HERE)/%.cmi.d: $(HERE)/%.mli

$(MY_MLL_ML):  $(TEMP_DIR)/$(REL_HERE)/%.ml:    $(HERE)/%.mll
$(MY_MLL_OBJ): $(TEMP_DIR)/$(REL_HERE)/%.cmo:   $(TEMP_DIR)/$(REL_HERE)/%.ml
$(MY_MLL_DEP): $(TEMP_DIR)/$(REL_HERE)/%.cmo.d: $(TEMP_DIR)/$(REL_HERE)/%.ml

$(MY_MLY_ML):   $(TEMP_DIR)/$(REL_HERE)/%.ml:    $(HERE)/%.mly
$(MY_MLY_MLI):  $(TEMP_DIR)/$(REL_HERE)/%.mli:   $(HERE)/%.mly
$(MY_MLY_OBJ):  $(TEMP_DIR)/$(REL_HERE)/%.cmo:   $(TEMP_DIR)/$(REL_HERE)/%.ml
$(MY_MLY_OBJI): $(TEMP_DIR)/$(REL_HERE)/%.cmi:   $(TEMP_DIR)/$(REL_HERE)/%.mli
$(MY_MLY_DEP):  $(TEMP_DIR)/$(REL_HERE)/%.cmo.d: $(TEMP_DIR)/$(REL_HERE)/%.ml
$(MY_MLY_DEPI): $(TEMP_DIR)/$(REL_HERE)/%.cmi.d: $(TEMP_DIR)/$(REL_HERE)/%.mli

# Order is important here. The rules.mk.inc file uses scripts/ocamlorder
# to ensure it is ok.

$(MY_BIN): $(MY_MLY_OBJ) $(MY_MLL_OBJ) $(MY_ML_OBJ)

# Unset this so future included Makefiles can set it up
MY_BIN :=
