#!/bin/sh

if [ $1 != "failure" ]; then

echo "------------ Testing FVPL success cases ------------"
for i in tests/success/*.input; do
	ARGS="$i" make exec 1>/dev/null; ./a.out > /tmp/out
	k=`basename $i .input`
	
	diff -w -i /tmp/out tests/success/$k.output > /dev/null
	if [ $? -eq 0 ]; then
		echo "$i --------------- SUCCESS"
	else 
		echo "$i --------------- FAIL"
	fi
done
fi

if [ $1 != "success" ]
	then

 echo "\n\n------------ Testing FVPL failure cases ------------"
 for i in tests/failure/*.input; do
	./fvpl < $i > /tmp/tmp.c
	if [ $? -eq 0 ]
	 then
	 	g++ -DLINUX -msse2 -msse3  -I./ /tmp/tmp.c
	 	./a.out > /dev/null
	 	if [ $? -eq 0 ] 
	 	then
			echo "$i --------------- SUCCESS"
		else
			echo "$i --------------- FAIL"
		fi
	else 
		echo "$i --------------- FAIL"
	fi
done

fi