open Ast

exception SemanticError

let global_scope = ref 0;; (* 0 = local scope, 1 = global scope *)
let error_msg = ref "";;

let raise_error msg = 
	error_msg := msg;
	raise SemanticError

let sym_table = ref [(NULL,"",0)];;
let g_sym_table = ref [(NULL,"",0)];;

(* (-1, type) -> -1 indicates scalar *)
let f_sym_table = ref [ ("fread_float", 3, [(-1,StrType);(0,Float);(-1,Int)]);
						("fread_int", 3, [(-1,StrType);(0,Int);(-1,Int)]);  
						("fwrite_float", 3, [(-1,StrType);(0,Float);(-1,Int)]);
						("fwrite_int", 3, [(-1,StrType);(0,Int);(-1,Int)]); 
						("copy_vector", -1, [(-3,NULL)]); ("",0,[(-3,NULL)])];;

let dtype_eval_d = function
	Int -> "int"
	| Int8 -> "int8"
	| Float -> "float"
	| _ -> raise_error "Invalid data type"
	;;

let debug_tuple (vflag, dtype) = 
	let x1 = dtype_eval_d dtype in 
			print_string ("VLAG="^string_of_int(vflag)^"  "^x1^" \n")
	;;
	
let fun_arg_type_eval fname alen exprlist = 
	let rec fun_arg_type_eval_each = function
                            [] -> raise_error "EXCEPTION!!"
                            | (funame, asize, typelist)::l -> 
							
                            if (fname=funame) then 
                                begin
                                if (asize != -1) then (* variable number of args*)
                                    begin
                                    if (asize != alen) then
                                        raise_error ("number of params different " ^ 
                                        string_of_int (List.length typelist));
                                        if (( typelist) <> (exprlist)) then
                                        begin
                                        (*List.iter debug_tuple exprlist;*)
                                        raise_error ("Type of arguments not matching defined function" ^ 
                                        string_of_int(List.length exprlist))
                                        end
                                    end (* asize!= -1*)
                                end
                            else fun_arg_type_eval_each l
                            in
                        fun_arg_type_eval_each !f_sym_table
        ;;
														
let f_find_sym fname = 
	let rec find_sym = function [] -> false
			|(funame,_,_)::l -> if (fname = funame) then true else find_sym l
			in
		find_sym !f_sym_table 
		;;


let f_insert_sym fname num_arg type_arg_list = 
	let rec g_find_sym = function [] -> false
			|(typename,var,size)::l -> if (var = fname) then true else g_find_sym l
	in
			if g_find_sym !g_sym_table = true then
				raise_error "Cannot have function name same as global var";
			if f_find_sym fname = true then (* Check if function already exists *)
				ignore(raise_error ("Redeclaration of id similar to global function "^fname))
			else
				ignore (f_sym_table:= (fname, num_arg, type_arg_list)::!f_sym_table)




let insert_symbol dtype sym size = 
let rec find_sym = function [] -> false
			|(typename,var,size)::l -> if (var = sym) then true else find_sym l
			in
	if f_find_sym sym = true then
		raise_error "Cannot have ID same name as function";
	if !global_scope = 0 then (* local sym table *)
		begin
			
			if find_sym !sym_table = true then (* Check if symbol already exists *)
			ignore(raise_error ("Redeclaration of local id "^sym))
		else
			ignore(sym_table:=  (dtype,sym,size)::!sym_table);
		end
	else
		begin
			if find_sym !g_sym_table = true then (* Check if symbol already exists in global scope *)
			ignore(raise_error ("Redeclaration of global id "^sym))
		else
			ignore(g_sym_table:=  (dtype,sym,size)::!g_sym_table);
		end


(* Insert const values into global scope, unique instance of each value *)
let insert_symbol_const dtype sym size = 
let rec find_sym = function [] -> false
			|(typename,var,size)::l -> if (var = sym) then true else find_sym l
			in
			if find_sym !g_sym_table != true then (* Check if symbol already exists *)
			ignore(g_sym_table:=  (dtype,sym,size)::!g_sym_table)
			

let lookup_symbol sym = (* error if sym does not exist *)
	let rec find_sym = function [] -> false
			|(typename,var,size)::l -> if (var = sym) then true else find_sym l
	in
	let k = find_sym !sym_table  in 
	if k = false then
		begin
			let j = find_sym !g_sym_table in
			if j = false then 
				ignore (raise_error ("Encountered undefined symbol "^sym))
		end
	


let get_valid = function (t, v, s)-> v

(*check if availble, if yes, then return the tuple*)
let symbol_detail sym = 
	let rec find_sym = function []-> (NULL,"",0)
				|(typename,var,size)::l -> if (var = sym) then (typename,var,size) else find_sym l
in let k = find_sym !sym_table
in
	if get_valid k = "" then find_sym !g_sym_table
	else k


let clear_symtable () = 
	sym_table:= [(NULL,"",0)];;
