{ open Parser 
let fullstr = ref "";;
}

let digit=['0'-'9']
let float_digit = ['-''+']?['0'-'9']+['.']['0'-'9']* (['e''E'](['-''+']?(['0'-'9']+)?))?
| ['-''+']?['0'-'9']*['.']['0'-'9']+ (['e''E'](['-''+']?(['0'-'9']+)?))?
| ['-''+']?['0'-'9']*['.']?['0'-'9']+ (['e''E']['-''+']?(['0'-'9']+)?)

let string = "(['0'-'9''a'-'z''A'-'Z'])*"

rule token = parse
| eof 			{ EOF }
| "print"		{ PRINT }
| "if" 			{ IF}
| "else" 		{ ELSE}
| "for" 		{ FOR}
| "while"		{ WHILE }
| "return"		{ RETURN}
| "continue"	{ CONTINUE}
| "break"		{ BREAK}
| "int"			{ INT}
| "float" 		{ FLOAT}
| "int8"		{ INT8}
| "void"		{ VOID}
| '"'			{ fullstr:=""; str_quote lexbuf }
| '('           { LPARAN}
| ')'           { RPARAN}
| '{'           { LBRACE}
| '}'           { RBRACE}
| '['			{ LBRACKET}
| ']'			{ RBRACKET}
| "++"			{ PLUSPLUS }
| "--"			{ MINUSMINUS }
| '+'			{ PLUS}
| '-'			{ MINUS}
| '*'			{ MUL}
| '/'			{ DIV}
| '|'           { OR}
| '&'			{ AND}
| '^'			{ XOR}
| '~' 			{ NOT}
| '='           { ASN}
| ';'			{ SEP}
| ','           { COMMA}
| '<'			{ LT}
| '>'			{ GT}
| "<="			{ LTEQ}
| ">="			{ GTEQ}
| "=="			{ EQ}
| "!="			{ NOTEQ}
| float_digit as f_digit { FDIGIT (f_digit) }
| digit+ 	as digi	{ DIGIT(int_of_string(digi)) }
| ['a'-'z' 'A'-'Z']+(digit|['a'-'z''A'-'Z''_'])* as id_str { ID(id_str)}
| "/*"     { multi_comment lexbuf }
| "//"	   { single_comment lexbuf }
| _ { token lexbuf }

and single_comment = parse
 "\n" {token lexbuf }
 |_   { single_comment lexbuf }
 
and multi_comment = parse
  "*/" { token lexbuf }
| _    { multi_comment lexbuf }

and str_quote = parse
  '"' { STRING (!fullstr) }
  | _ as str { fullstr:= !fullstr^(String.make 1 str); str_quote lexbuf }


{
	
}


