%{ open Ast 
 	let parse_error msg =
 		print_endline (msg);
 		flush stdout
 %}

%token EOF  IF  ELSE  WHILE  FOR  RETURN  LBRACKET   RBRACKET
  CONTINUE  BREAK INT  FLOAT INT8  
  VOID  LPARAN  RPARAN  LBRACE  RBRACE  PLUS  MINUS  MUL  DIV 
  OR  AND  XOR  NOT  ASN  SEP  COMMA  LT  GT  LTEQ  GTEQ  EQ  NOTEQ  RETURN PRINT QUOTES PLUSPLUS MINUSMINUS WHILE

%token PLUS MINUS TIMES DIVIDE EOF SEQ ASN
%token <string> ID
%token <int> DIGIT
%token <string> FDIGIT
%token <string> STRING

%left COMMA
%right ASN
%left OR AND XOR 
%left EQ NOTEQ
%left LT GT LTEQ GTEQ
%left PLUS MINUS
%left TIMES DIVIDE
%left PLUSPLUS MINUSMINUS

%start program
%type <Ast.program> program


%%

program: 
							{ [],[] } /* pass a tuple to interpreter, first = global decs, second = fun defs */
				| g_decl  program  { ($1::fst $2), snd $2 }  
				| fun_def program { fst $2, ($1::snd $2) }


fun_def : INT ID LPARAN fun_def_args_list RPARAN LBRACE decl_list stmt_list RBRACE { 
					{ fun_name = $2;
						arg_list = $4;
						decl_list = $7;
						stmt_list = $8};} 
						
fun_def_args_list : fun_def_args_list COMMA  fun_def_args {$3::$1}
				| fun_def_args {[$1]}
				| {[]}
					

fun_def_args:   datatype ID {FunArg ($1,$2,-1)}
			| datatype ID LBRACKET DIGIT RBRACKET{ FunArg ($1,$2,$4) } /* For arrays */
								

/* first part of func decl list */

stmt_list : 
		{ [] }
		|stmt stmt_list{$1::$2} 

			
stmt:   IF LPARAN expr RPARAN LBRACE stmt_list RBRACE elsetag { If ($3,$6,$8) } /* If statement */
			| ID ASN stmt { Assign($1,$3,1) } /* assignment */
			| FOR LPARAN init_stmt SEP opt_expr SEP init_stmt RPARAN LBRACE stmt_list RBRACE {  For($3,$5,$7,$10) } /* looping (**)*/
			| WHILE LPARAN expr RPARAN LBRACE stmt_list RBRACE {While ($3,$6) }
			| expr SEP{ Expr($1,1) } /* Just an expression, i++ */
			| PRINT LPARAN  STRING  RPARAN SEP {Print_string ($3) } /* Print string */
			| PRINT LPARAN ID RPARAN SEP {  Print ($3) } /* print identifiers */
			| PRINT LPARAN DIGIT RPARAN SEP { Print_const (string_of_int($3), Int) } /* print numbers */
			| PRINT LPARAN FDIGIT RPARAN SEP { Print_const (($3), Float) } /* print numbers */
			| ID LPARAN arg_list RPARAN SEP {  FunCall ($1, $3) } /* Function call . Arguments are expr list */
			| RETURN opt_bracket_l expr opt_bracket_r SEP { Return ($3) }
			| CONTINUE SEP { Continue }
			| BREAK SEP { Break }
			
opt_expr: expr { $1 }
		| { ExprEmpty}
		
opt_bracket_l: LPARAN {}
				| {}

opt_bracket_r: RPARAN {}
				| {}

elsetag: ELSE LBRACE stmt_list RBRACE { $3 }
				| {[]}

arg_list:  expr COMMA arg_list { $1::$3 }
					|expr{[$1]}
					| {[]}

/* handle expressions */
expr:  
		expr PLUS term { Binop($1,Plus,$3) }
		| expr MINUS term {Binop ($1,Minus,$3) }
		| expr OR term {Binop ($1, Or,$3)}
		| expr AND term {Binop ($1, And,$3)} 
		| expr XOR term {Binop ($1, Xor,$3)}
		| expr LT term {Binop ($1, Lt,$3)}
		| expr GT term {Binop ($1, Gt,$3)}
		| expr LTEQ term{Binop ($1, Lteq,$3)}
		| expr GTEQ term{Binop ($1, Gteq,$3)}
		| expr EQ term{Binop ($1, Eq,$3)}
		| expr NOTEQ term{Binop ($1, NotEq,$3)}
		| ID PLUSPLUS {Uop ($1,PlusP)}
		| ID MINUSMINUS {Uop($1,MinusM)}
		| LBRACE int_id_list RBRACE { IntArray ($2) }
		| LBRACE f_id_list RBRACE {FloatArray ($2) }
		| term { $1 }
		| STRING { String($1) }


term: term MUL atom { Binop($1, Mul, $3) }
	| term DIV atom { Binop($1, Div, $3) }
	| atom { $1 }
	
f_id_list: FDIGIT COMMA f_id_list { $1::$3 }
		| FDIGIT {[$1]}

int_id_list: DIGIT COMMA int_id_list { $1::$3 }
		| DIGIT {[$1]}
	
atom: DIGIT {Literal($1) }
	| FDIGIT { FloatL ($1) }
	| ID { Id($1) }

		
init_stmt: ID ASN expr {Assign($1,Expr($3,0),0)} /* comma separated values */
		| expr { Expr ($1,0) }
		| {Empty}

/* Handle decl_list (& globals) and derivatives from now on */

g_decl:  INT var_decl SEP { Var_list (Int,$2) }
		|FLOAT var_decl SEP { Var_list(Float, $2) }
		|INT8 var_decl SEP { Var_list(Int8,$2) }

decl_list: decl decl_list { $1::$2 } /* variable declaration */
		|{[]}

decl: datatype var_decl SEP { Var_list ($1,$2) }

var_decl : var COMMA var_decl { $1::$3 }
		| var{ [$1] }

		
var : ID { Var_Decl ($1,-1) } /* -1 indicates no dimension */
		| ID LBRACKET DIGIT RBRACKET{ Var_Decl ($1,$3) } /* For arrays */


datatype: 	INT{Int }
		| FLOAT{Float }
		| INT8{Int8 }



			
		