open Ast

let _ =
try
  let lexbuf = Lexing.from_channel stdin in
  let program = Parser.program Scanner.token lexbuf in 	
  (Interpret.eval program);
 with End_of_file -> exit 0
 | Parsing.Parse_error -> ignore(failwith "Parser syntax error"); exit 1
 | Interpret.SemanticError -> ignore(failwith !Interpret.error_msg); exit 1
 | Symbol.SemanticError -> ignore(failwith !Symbol.error_msg); exit 1