
type uop = 
	PlusP
	| MinusM
	
	
type operator = 
	Plus 
		|Minus
		| Mul
		| Div
		| Or
		| And
		| Xor
		| Lt
		| Gt
		| Lteq
		| Gteq
		| Eq
		| NotEq 


type expr = 
	Literal of int
	| FloatL of string
	| Id of string
	| IntArray of int list
	| FloatArray of string list
	| Binop of expr * operator * expr
	| Uop of string * uop
	| String of string
	| ExprEmpty
	
type datatype = 
	Int
	|Int8
	| Float
	| NULL
	| Function (* Type with which functions are stored in global sym table *)
	| StrType

type var = 
	Var_Decl of string * int


type decl = 
	Var_list of datatype * var list

 type stmt = 
		 Expr of expr * int
		|Return of expr
		| If of expr * stmt list * stmt list
		| For of stmt * expr * stmt * stmt list
		| While of expr * stmt list
		| Dummy_str of string
		| Assign of string * stmt * int
		| FunCall of string * expr list
		| Continue
		| Break
		| Print of string
		| Print_const of string * datatype
		| Print_string of string
		| Empty

type funarg = 
		FunArg of datatype * string * int
		
	
type fun_def = { (* ret_type is always an int *)
	fun_name: string;
	arg_list: funarg list;
	decl_list: decl list;
	stmt_list: stmt list;
	}
	
type program = decl list * fun_def list 
