public class Set extends Stmt {
    public Id lvalue;
    public Expr expr;
    public Set(Id i, Expr x) {
	lvalue = i;
	expr = x;
	if (check(lvalue.type, expr.type) == null) error("type error");
    }
    public Type check(Type p1, Type p2) {
	if (p1 instanceof Array || p2 instanceof Array) return null;
	if (p1 == p2) return p2;
	if (Type.numeric(p1) && Type.numeric(p2)) return p2;
	else if (p1 == Type.Bool && p2 == Type.Bool) return p2;
	else return null;
    }
    public void gen(int b, int a) {
	emit(lvalue.toString() + " = " + expr.gen().toString());
    }
}
