// $ANTLR 2.7.2: "grammar.g" -> "MyWalker.java"$

import antlr.TreeParser;
import antlr.Token;
import antlr.collections.AST;
import antlr.RecognitionException;
import antlr.ANTLRException;
import antlr.NoViableAltException;
import antlr.MismatchedTokenException;
import antlr.SemanticException;
import antlr.collections.impl.BitSet;
import antlr.ASTPair;
import antlr.collections.impl.ASTArray;


/***********************************************************************

   A tree walker that builds up an IR that can easily be converted
			to three-address-code

 ***********************************************************************/
public class MyWalker extends antlr.TreeParser       implements MyLexerTokenTypes
 {

  SymbolTable top = null;
  int used = 0; // Number of bytes allocated for local declarations
public MyWalker() {
	tokenNames = _tokenNames;
}

	public final Stmt  program(AST _t) throws RecognitionException {
		Stmt s;
		
		AST program_AST_in = (AST)_t;
		s = null; Stmt s1;
		
		try {      // for error handling
			AST __t74 = _t;
			AST tmp1_AST_in = (AST)_t;
			match(_t,LBRACE);
			_t = _t.getFirstChild();
			SymbolTable saved_environment = top; top = new SymbolTable(top);
			decls(_t);
			_t = _retTree;
			s=stmts(_t);
			_t = _retTree;
			top = saved_environment;
			_t = __t74;
			_t = _t.getNextSibling();
		}
		catch (RecognitionException ex) {
			reportError(ex);
			if (_t!=null) {_t = _t.getNextSibling();}
		}
		_retTree = _t;
		return s;
	}
	
	public final void decls(AST _t) throws RecognitionException {
		
		AST decls_AST_in = (AST)_t;
		Type t = null;
		
		try {      // for error handling
			AST __t76 = _t;
			AST tmp2_AST_in = (AST)_t;
			match(_t,DECLS);
			_t = _t.getFirstChild();
			{
			_loop78:
			do {
				if (_t==null) _t=ASTNULL;
				if (((_t.getType() >= LITERAL_int && _t.getType() <= LITERAL_float))) {
					t=type(_t);
					_t = _retTree;
					AST tmp3_AST_in = (AST)_t;
					match(_t,ID);
					_t = _t.getNextSibling();
					top.put(tmp3_AST_in.getText(), t, used); used += t.width;
				}
				else {
					break _loop78;
				}
				
			} while (true);
			}
			_t = __t76;
			_t = _t.getNextSibling();
		}
		catch (RecognitionException ex) {
			reportError(ex);
			if (_t!=null) {_t = _t.getNextSibling();}
		}
		_retTree = _t;
	}
	
	public final Stmt  stmts(AST _t) throws RecognitionException {
		Stmt s;
		
		AST stmts_AST_in = (AST)_t;
		s = null; Stmt s1;
		
		try {      // for error handling
			s=stmt(_t);
			_t = _retTree;
			{
			if (_t==null) _t=ASTNULL;
			switch ( _t.getType()) {
			case SEMI:
			case ASSIGN:
			case LBRACE:
			case LITERAL_if:
			case LITERAL_while:
			case LITERAL_do:
			case LITERAL_break:
			{
				s1=stmts(_t);
				_t = _retTree;
				s = new Seq(s, s1);
				break;
			}
			case 3:
			{
				break;
			}
			default:
			{
				throw new NoViableAltException(_t);
			}
			}
			}
		}
		catch (RecognitionException ex) {
			reportError(ex);
			if (_t!=null) {_t = _t.getNextSibling();}
		}
		_retTree = _t;
		return s;
	}
	
	public final Type  type(AST _t) throws RecognitionException {
		Type t;
		
		AST type_AST_in = (AST)_t;
		t = null;
		
		try {      // for error handling
			{
			if (_t==null) _t=ASTNULL;
			switch ( _t.getType()) {
			case LITERAL_bool:
			{
				AST tmp4_AST_in = (AST)_t;
				match(_t,LITERAL_bool);
				_t = _t.getNextSibling();
				t = Type.Bool;
				break;
			}
			case LITERAL_char:
			{
				AST tmp5_AST_in = (AST)_t;
				match(_t,LITERAL_char);
				_t = _t.getNextSibling();
				t = Type.Char;
				break;
			}
			case LITERAL_int:
			{
				AST tmp6_AST_in = (AST)_t;
				match(_t,LITERAL_int);
				_t = _t.getNextSibling();
				t = Type.Int;
				break;
			}
			case LITERAL_float:
			{
				AST tmp7_AST_in = (AST)_t;
				match(_t,LITERAL_float);
				_t = _t.getNextSibling();
				t = Type.Float;
				break;
			}
			default:
			{
				throw new NoViableAltException(_t);
			}
			}
			}
			{
			if (_t==null) _t=ASTNULL;
			switch ( _t.getType()) {
			case NUM:
			{
				t=dims(_t,t);
				_t = _retTree;
				break;
			}
			case ID:
			{
				break;
			}
			default:
			{
				throw new NoViableAltException(_t);
			}
			}
			}
		}
		catch (RecognitionException ex) {
			reportError(ex);
			if (_t!=null) {_t = _t.getNextSibling();}
		}
		_retTree = _t;
		return t;
	}
	
	public final Type  dims(AST _t,
		Type t1
	) throws RecognitionException {
		Type t;
		
		AST dims_AST_in = (AST)_t;
		t = t1;
		
		try {      // for error handling
			AST tmp8_AST_in = (AST)_t;
			match(_t,NUM);
			_t = _t.getNextSibling();
			{
			if (_t==null) _t=ASTNULL;
			switch ( _t.getType()) {
			case NUM:
			{
				t=dims(_t,t);
				_t = _retTree;
				break;
			}
			case ID:
			{
				break;
			}
			default:
			{
				throw new NoViableAltException(_t);
			}
			}
			}
			t = new Array(Integer.parseInt(tmp8_AST_in.getText()), t);
		}
		catch (RecognitionException ex) {
			reportError(ex);
			if (_t!=null) {_t = _t.getNextSibling();}
		}
		_retTree = _t;
		return t;
	}
	
	public final Stmt  stmt(AST _t) throws RecognitionException {
		Stmt s;
		
		AST stmt_AST_in = (AST)_t;
		Expr e1, e2;
		s = null;
		Stmt s1, s2;
		
		
		try {      // for error handling
			if (_t==null) _t=ASTNULL;
			switch ( _t.getType()) {
			case ASSIGN:
			{
				AST __t87 = _t;
				AST tmp9_AST_in = (AST)_t;
				match(_t,ASSIGN);
				_t = _t.getFirstChild();
				e1=expr(_t);
				_t = _retTree;
				e2=expr(_t);
				_t = _retTree;
				if (e1 instanceof Id) s = new Set((Id) e1, e2);
				else s = new SetElem((Access) e1, e2);
				
				_t = __t87;
				_t = _t.getNextSibling();
				break;
			}
			case LITERAL_if:
			{
				AST __t88 = _t;
				AST tmp10_AST_in = (AST)_t;
				match(_t,LITERAL_if);
				_t = _t.getFirstChild();
				e1=expr(_t);
				_t = _retTree;
				s1=stmt(_t);
				_t = _retTree;
				{
				if (_t==null) _t=ASTNULL;
				switch ( _t.getType()) {
				case SEMI:
				case ASSIGN:
				case LBRACE:
				case LITERAL_if:
				case LITERAL_while:
				case LITERAL_do:
				case LITERAL_break:
				{
					s2=stmt(_t);
					_t = _retTree;
					s = new Else(e1, s1, s2);
					break;
				}
				case 3:
				{
					s = new If(e1, s1);
					break;
				}
				default:
				{
					throw new NoViableAltException(_t);
				}
				}
				}
				_t = __t88;
				_t = _t.getNextSibling();
				break;
			}
			case LITERAL_while:
			{
				AST __t90 = _t;
				AST tmp11_AST_in = (AST)_t;
				match(_t,LITERAL_while);
				_t = _t.getFirstChild();
				While whilenode = new While();
				s2 = Stmt.Enclosing;
				Stmt.Enclosing = whilenode;
				e1=expr(_t);
				_t = _retTree;
				s1=stmt(_t);
				_t = _retTree;
				whilenode.init(e1, s1);
				Stmt.Enclosing = s2;
				s = whilenode;
				_t = __t90;
				_t = _t.getNextSibling();
				break;
			}
			case LITERAL_do:
			{
				AST __t91 = _t;
				AST tmp12_AST_in = (AST)_t;
				match(_t,LITERAL_do);
				_t = _t.getFirstChild();
				Do donode = new Do();
				s2 = Stmt.Enclosing;
				Stmt.Enclosing = donode;
				s1=stmt(_t);
				_t = _retTree;
				e1=expr(_t);
				_t = _retTree;
				donode.init(s1, e1);
				Stmt.Enclosing = s2;
				s = donode;
				_t = __t91;
				_t = _t.getNextSibling();
				break;
			}
			case LITERAL_break:
			{
				AST tmp13_AST_in = (AST)_t;
				match(_t,LITERAL_break);
				_t = _t.getNextSibling();
				s = new Break();
				break;
			}
			case LBRACE:
			{
				s=program(_t);
				_t = _retTree;
				break;
			}
			case SEMI:
			{
				AST tmp14_AST_in = (AST)_t;
				match(_t,SEMI);
				_t = _t.getNextSibling();
				s = Stmt.Null;
				break;
			}
			default:
			{
				throw new NoViableAltException(_t);
			}
			}
		}
		catch (RecognitionException ex) {
			reportError(ex);
			if (_t!=null) {_t = _t.getNextSibling();}
		}
		_retTree = _t;
		return s;
	}
	
	public final Expr  expr(AST _t) throws RecognitionException {
		Expr e;
		
		AST expr_AST_in = (AST)_t;
		
		Expr a, b;
		e = null;
		
		
		try {      // for error handling
			if (_t==null) _t=ASTNULL;
			switch ( _t.getType()) {
			case OR:
			{
				AST __t93 = _t;
				AST tmp15_AST_in = (AST)_t;
				match(_t,OR);
				_t = _t.getFirstChild();
				a=expr(_t);
				_t = _retTree;
				b=expr(_t);
				_t = _retTree;
				e = new Or(a, b);
				_t = __t93;
				_t = _t.getNextSibling();
				break;
			}
			case AND:
			{
				AST __t94 = _t;
				AST tmp16_AST_in = (AST)_t;
				match(_t,AND);
				_t = _t.getFirstChild();
				a=expr(_t);
				_t = _retTree;
				b=expr(_t);
				_t = _retTree;
				e = new And(a, b);
				_t = __t94;
				_t = _t.getNextSibling();
				break;
			}
			case EQ:
			{
				AST __t95 = _t;
				AST tmp17_AST_in = (AST)_t;
				match(_t,EQ);
				_t = _t.getFirstChild();
				a=expr(_t);
				_t = _retTree;
				b=expr(_t);
				_t = _retTree;
				e = new Rel("==", a, b);
				_t = __t95;
				_t = _t.getNextSibling();
				break;
			}
			case NE:
			{
				AST __t96 = _t;
				AST tmp18_AST_in = (AST)_t;
				match(_t,NE);
				_t = _t.getFirstChild();
				a=expr(_t);
				_t = _retTree;
				b=expr(_t);
				_t = _retTree;
				e = new Rel("!=", a, b);
				_t = __t96;
				_t = _t.getNextSibling();
				break;
			}
			case LT:
			{
				AST __t97 = _t;
				AST tmp19_AST_in = (AST)_t;
				match(_t,LT);
				_t = _t.getFirstChild();
				a=expr(_t);
				_t = _retTree;
				b=expr(_t);
				_t = _retTree;
				e = new Rel("<", a, b);
				_t = __t97;
				_t = _t.getNextSibling();
				break;
			}
			case LE:
			{
				AST __t98 = _t;
				AST tmp20_AST_in = (AST)_t;
				match(_t,LE);
				_t = _t.getFirstChild();
				a=expr(_t);
				_t = _retTree;
				b=expr(_t);
				_t = _retTree;
				e = new Rel("<=", a, b);
				_t = __t98;
				_t = _t.getNextSibling();
				break;
			}
			case GT:
			{
				AST __t99 = _t;
				AST tmp21_AST_in = (AST)_t;
				match(_t,GT);
				_t = _t.getFirstChild();
				a=expr(_t);
				_t = _retTree;
				b=expr(_t);
				_t = _retTree;
				e = new Rel(">", a, b);
				_t = __t99;
				_t = _t.getNextSibling();
				break;
			}
			case GE:
			{
				AST __t100 = _t;
				AST tmp22_AST_in = (AST)_t;
				match(_t,GE);
				_t = _t.getFirstChild();
				a=expr(_t);
				_t = _retTree;
				b=expr(_t);
				_t = _retTree;
				e = new Rel(">=", a, b);
				_t = __t100;
				_t = _t.getNextSibling();
				break;
			}
			case PLUS:
			{
				AST __t101 = _t;
				AST tmp23_AST_in = (AST)_t;
				match(_t,PLUS);
				_t = _t.getFirstChild();
				a=expr(_t);
				_t = _retTree;
				b=expr(_t);
				_t = _retTree;
				e = new Arith("+", a, b);
				_t = __t101;
				_t = _t.getNextSibling();
				break;
			}
			case MINUS:
			{
				AST __t102 = _t;
				AST tmp24_AST_in = (AST)_t;
				match(_t,MINUS);
				_t = _t.getFirstChild();
				a=expr(_t);
				_t = _retTree;
				b=expr(_t);
				_t = _retTree;
				e = new Arith("-", a, b);
				_t = __t102;
				_t = _t.getNextSibling();
				break;
			}
			case MUL:
			{
				AST __t103 = _t;
				AST tmp25_AST_in = (AST)_t;
				match(_t,MUL);
				_t = _t.getFirstChild();
				a=expr(_t);
				_t = _retTree;
				b=expr(_t);
				_t = _retTree;
				e = new Arith("*", a, b);
				_t = __t103;
				_t = _t.getNextSibling();
				break;
			}
			case DIV:
			{
				AST __t104 = _t;
				AST tmp26_AST_in = (AST)_t;
				match(_t,DIV);
				_t = _t.getFirstChild();
				a=expr(_t);
				_t = _retTree;
				b=expr(_t);
				_t = _retTree;
				e = new Arith("/", a, b);
				_t = __t104;
				_t = _t.getNextSibling();
				break;
			}
			case NOT:
			{
				AST __t105 = _t;
				AST tmp27_AST_in = (AST)_t;
				match(_t,NOT);
				_t = _t.getFirstChild();
				a=expr(_t);
				_t = _retTree;
				e = new Not(a);
				_t = __t105;
				_t = _t.getNextSibling();
				break;
			}
			case NEGATE:
			{
				AST __t106 = _t;
				AST tmp28_AST_in = (AST)_t;
				match(_t,NEGATE);
				_t = _t.getFirstChild();
				a=expr(_t);
				_t = _retTree;
				e = new Unary("-", a);
				_t = __t106;
				_t = _t.getNextSibling();
				break;
			}
			case NUM:
			{
				AST tmp29_AST_in = (AST)_t;
				match(_t,NUM);
				_t = _t.getNextSibling();
				e = new Constant(tmp29_AST_in.getText(), Type.Int);
				break;
			}
			case REAL:
			{
				AST tmp30_AST_in = (AST)_t;
				match(_t,REAL);
				_t = _t.getNextSibling();
				e = new Constant(tmp30_AST_in.getText(), Type.Float);
				break;
			}
			case LITERAL_true:
			{
				AST tmp31_AST_in = (AST)_t;
				match(_t,LITERAL_true);
				_t = _t.getNextSibling();
				e = Constant.True;
				break;
			}
			case LITERAL_false:
			{
				AST tmp32_AST_in = (AST)_t;
				match(_t,LITERAL_false);
				_t = _t.getNextSibling();
				e = Constant.False;
				break;
			}
			case ID:
			{
				AST __t107 = _t;
				AST tmp33_AST_in = (AST)_t;
				match(_t,ID);
				_t = _t.getFirstChild();
				Id i = top.get(tmp33_AST_in.getText());
				if (i == null) System.out.println(tmp33_AST_in.getText() + " undeclared");
				e = i;
				
				{
				if (_t==null) _t=ASTNULL;
				switch ( _t.getType()) {
				case NUM:
				case AND:
				case LE:
				case OR:
				case GT:
				case GE:
				case EQ:
				case PLUS:
				case NOT:
				case MINUS:
				case NE:
				case MUL:
				case LT:
				case DIV:
				case ID:
				case NEGATE:
				case REAL:
				case LITERAL_true:
				case LITERAL_false:
				{
					a=expr(_t);
					_t = _retTree;
					Type type = e.type;
					type = ((Array)type).of;
					Expr w = new Constant(type.width);
					Expr loc = new Arith("*", a, w);
					
					{
					_loop110:
					do {
						if (_t==null) _t=ASTNULL;
						if ((_tokenSet_0.member(_t.getType()))) {
							a=expr(_t);
							_t = _retTree;
							type = ((Array)type).of;
							w = new Constant(type.width);
							loc = new Arith("+", loc, new Arith("*", a, w));
							
						}
						else {
							break _loop110;
						}
						
					} while (true);
					}
					e = new Access(i, loc, type);
					break;
				}
				case 3:
				{
					break;
				}
				default:
				{
					throw new NoViableAltException(_t);
				}
				}
				}
				_t = __t107;
				_t = _t.getNextSibling();
				break;
			}
			default:
			{
				throw new NoViableAltException(_t);
			}
			}
		}
		catch (RecognitionException ex) {
			reportError(ex);
			if (_t!=null) {_t = _t.getNextSibling();}
		}
		_retTree = _t;
		return e;
	}
	
	
	public static final String[] _tokenNames = {
		"<0>",
		"EOF",
		"<2>",
		"NULL_TREE_LOOKAHEAD",
		"WHITESPACE",
		"DIGITS",
		"NUM",
		"AND",
		"LE",
		"SEMI",
		"OR",
		"GT",
		"LPAREN",
		"ASSIGN",
		"GE",
		"RPAREN",
		"EQ",
		"LBRACE",
		"PLUS",
		"NOT",
		"RBRACE",
		"MINUS",
		"NE",
		"LBRACK",
		"MUL",
		"LT",
		"RBRACK",
		"DIV",
		"ID",
		"NEGATE",
		"DECLS",
		"\"int\"",
		"\"char\"",
		"\"bool\"",
		"\"float\"",
		"\"if\"",
		"\"else\"",
		"\"while\"",
		"\"do\"",
		"\"break\"",
		"REAL",
		"\"true\"",
		"\"false\""
	};
	
	private static final long[] mk_tokenSet_0() {
		long[] data = { 7697578413504L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_0 = new BitSet(mk_tokenSet_0());
	}
	
