// $ANTLR 2.7.2: "grammar.g" -> "MyParser.java"$

import antlr.TokenBuffer;
import antlr.TokenStreamException;
import antlr.TokenStreamIOException;
import antlr.ANTLRException;
import antlr.LLkParser;
import antlr.Token;
import antlr.TokenStream;
import antlr.RecognitionException;
import antlr.NoViableAltException;
import antlr.MismatchedTokenException;
import antlr.SemanticException;
import antlr.ParserSharedInputState;
import antlr.collections.impl.BitSet;
import antlr.collections.AST;
import java.util.Hashtable;
import antlr.ASTFactory;
import antlr.ASTPair;
import antlr.collections.impl.ASTArray;

/***********************************************************************

                              The Parser

This parses the following grammar:

program  ->  block
block    ->  { decls stmts }
decls    ->  decls decl | e
decl     ->  type ID ;
type     ->  type [ NUM ] | basic
stmts    ->  stmts stmt | e
stmt     ->  loc = bool ;
         |   IF ( bool ) stmt
         |   IF ( bool ) stmt ELSE stmt
         |   WHILE ( bool ) stmt
         |   DO stmt WHILE ( bool ) ;
         |   BREAK ;
         |   block
         |   ;
loc      ->  loc [ bool ] | ID
bool     ->  bool || join | join
join     ->  join && equality | equality
equality ->  equality == rel | equality != rel | rel
rel      ->  expr < expr | expr <= expr | expr >= expr
         |   expr > expr | expr
expr     -> expr + term | expr - term | term
term     ->  term * unary | term / unary | unary
unary    ->  ! unary | - unary | factor
factor   ->  ( bool ) | loc | NUM | REAL | TRUE | FALSE

The empty statement is not part of the grammar given in the book, but it is
part of the Java parser code in Appendix A.

 ***********************************************************************/
public class MyParser extends antlr.LLkParser       implements MyLexerTokenTypes
 {

protected MyParser(TokenBuffer tokenBuf, int k) {
  super(tokenBuf,k);
  tokenNames = _tokenNames;
  buildTokenTypeASTClassMap();
  astFactory = new ASTFactory(getTokenTypeToASTClassMap());
}

public MyParser(TokenBuffer tokenBuf) {
  this(tokenBuf,1);
}

protected MyParser(TokenStream lexer, int k) {
  super(lexer,k);
  tokenNames = _tokenNames;
  buildTokenTypeASTClassMap();
  astFactory = new ASTFactory(getTokenTypeToASTClassMap());
}

public MyParser(TokenStream lexer) {
  this(lexer,1);
}

public MyParser(ParserSharedInputState state) {
  super(state,1);
  tokenNames = _tokenNames;
  buildTokenTypeASTClassMap();
  astFactory = new ASTFactory(getTokenTypeToASTClassMap());
}

	public final void program() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST program_AST = null;
		
		try {      // for error handling
			AST tmp34_AST = null;
			tmp34_AST = astFactory.create(LT(1));
			astFactory.makeASTRoot(currentAST, tmp34_AST);
			match(LBRACE);
			decls();
			astFactory.addASTChild(currentAST, returnAST);
			{
			_loop36:
			do {
				if ((_tokenSet_0.member(LA(1)))) {
					stmt();
					astFactory.addASTChild(currentAST, returnAST);
				}
				else {
					break _loop36;
				}
				
			} while (true);
			}
			match(RBRACE);
			program_AST = (AST)currentAST.root;
		}
		catch (RecognitionException ex) {
			reportError(ex);
			consume();
			consumeUntil(_tokenSet_1);
		}
		returnAST = program_AST;
	}
	
	public final void decls() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST decls_AST = null;
		
		try {      // for error handling
			{
			_loop39:
			do {
				if (((LA(1) >= LITERAL_int && LA(1) <= LITERAL_float))) {
					decl();
					astFactory.addASTChild(currentAST, returnAST);
				}
				else {
					break _loop39;
				}
				
			} while (true);
			}
			decls_AST = (AST)currentAST.root;
			decls_AST = (AST)astFactory.make( (new ASTArray(2)).add(astFactory.create(DECLS,"DECLS")).add(decls_AST));
			currentAST.root = decls_AST;
			currentAST.child = decls_AST!=null &&decls_AST.getFirstChild()!=null ?
				decls_AST.getFirstChild() : decls_AST;
			currentAST.advanceChildToEnd();
			decls_AST = (AST)currentAST.root;
		}
		catch (RecognitionException ex) {
			reportError(ex);
			consume();
			consumeUntil(_tokenSet_2);
		}
		returnAST = decls_AST;
	}
	
	public final void stmt() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST stmt_AST = null;
		
		try {      // for error handling
			switch ( LA(1)) {
			case ID:
			{
				loc();
				astFactory.addASTChild(currentAST, returnAST);
				AST tmp36_AST = null;
				tmp36_AST = astFactory.create(LT(1));
				astFactory.makeASTRoot(currentAST, tmp36_AST);
				match(ASSIGN);
				bool();
				astFactory.addASTChild(currentAST, returnAST);
				match(SEMI);
				stmt_AST = (AST)currentAST.root;
				break;
			}
			case LITERAL_if:
			{
				AST tmp38_AST = null;
				tmp38_AST = astFactory.create(LT(1));
				astFactory.makeASTRoot(currentAST, tmp38_AST);
				match(LITERAL_if);
				match(LPAREN);
				bool();
				astFactory.addASTChild(currentAST, returnAST);
				match(RPAREN);
				stmt();
				astFactory.addASTChild(currentAST, returnAST);
				{
				if ((LA(1)==LITERAL_else)) {
					match(LITERAL_else);
					stmt();
					astFactory.addASTChild(currentAST, returnAST);
				}
				else if ((_tokenSet_1.member(LA(1)))) {
				}
				else {
					throw new NoViableAltException(LT(1), getFilename());
				}
				
				}
				stmt_AST = (AST)currentAST.root;
				break;
			}
			case LITERAL_while:
			{
				AST tmp42_AST = null;
				tmp42_AST = astFactory.create(LT(1));
				astFactory.makeASTRoot(currentAST, tmp42_AST);
				match(LITERAL_while);
				match(LPAREN);
				bool();
				astFactory.addASTChild(currentAST, returnAST);
				match(RPAREN);
				stmt();
				astFactory.addASTChild(currentAST, returnAST);
				stmt_AST = (AST)currentAST.root;
				break;
			}
			case LITERAL_do:
			{
				AST tmp45_AST = null;
				tmp45_AST = astFactory.create(LT(1));
				astFactory.makeASTRoot(currentAST, tmp45_AST);
				match(LITERAL_do);
				stmt();
				astFactory.addASTChild(currentAST, returnAST);
				match(LITERAL_while);
				match(LPAREN);
				bool();
				astFactory.addASTChild(currentAST, returnAST);
				match(RPAREN);
				match(SEMI);
				stmt_AST = (AST)currentAST.root;
				break;
			}
			case LITERAL_break:
			{
				AST tmp50_AST = null;
				tmp50_AST = astFactory.create(LT(1));
				astFactory.addASTChild(currentAST, tmp50_AST);
				match(LITERAL_break);
				match(SEMI);
				stmt_AST = (AST)currentAST.root;
				break;
			}
			case LBRACE:
			{
				program();
				astFactory.addASTChild(currentAST, returnAST);
				stmt_AST = (AST)currentAST.root;
				break;
			}
			case SEMI:
			{
				AST tmp52_AST = null;
				tmp52_AST = astFactory.create(LT(1));
				astFactory.addASTChild(currentAST, tmp52_AST);
				match(SEMI);
				stmt_AST = (AST)currentAST.root;
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
		}
		catch (RecognitionException ex) {
			reportError(ex);
			consume();
			consumeUntil(_tokenSet_1);
		}
		returnAST = stmt_AST;
	}
	
	public final void decl() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST decl_AST = null;
		
		try {      // for error handling
			{
			switch ( LA(1)) {
			case LITERAL_int:
			{
				AST tmp53_AST = null;
				tmp53_AST = astFactory.create(LT(1));
				astFactory.addASTChild(currentAST, tmp53_AST);
				match(LITERAL_int);
				break;
			}
			case LITERAL_char:
			{
				AST tmp54_AST = null;
				tmp54_AST = astFactory.create(LT(1));
				astFactory.addASTChild(currentAST, tmp54_AST);
				match(LITERAL_char);
				break;
			}
			case LITERAL_bool:
			{
				AST tmp55_AST = null;
				tmp55_AST = astFactory.create(LT(1));
				astFactory.addASTChild(currentAST, tmp55_AST);
				match(LITERAL_bool);
				break;
			}
			case LITERAL_float:
			{
				AST tmp56_AST = null;
				tmp56_AST = astFactory.create(LT(1));
				astFactory.addASTChild(currentAST, tmp56_AST);
				match(LITERAL_float);
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
			}
			{
			_loop43:
			do {
				if ((LA(1)==LBRACK)) {
					match(LBRACK);
					AST tmp58_AST = null;
					tmp58_AST = astFactory.create(LT(1));
					astFactory.addASTChild(currentAST, tmp58_AST);
					match(NUM);
					match(RBRACK);
				}
				else {
					break _loop43;
				}
				
			} while (true);
			}
			AST tmp60_AST = null;
			tmp60_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp60_AST);
			match(ID);
			match(SEMI);
			decl_AST = (AST)currentAST.root;
		}
		catch (RecognitionException ex) {
			reportError(ex);
			consume();
			consumeUntil(_tokenSet_3);
		}
		returnAST = decl_AST;
	}
	
	public final void loc() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST loc_AST = null;
		
		try {      // for error handling
			AST tmp62_AST = null;
			tmp62_AST = astFactory.create(LT(1));
			astFactory.makeASTRoot(currentAST, tmp62_AST);
			match(ID);
			{
			_loop48:
			do {
				if ((LA(1)==LBRACK)) {
					match(LBRACK);
					bool();
					astFactory.addASTChild(currentAST, returnAST);
					match(RBRACK);
				}
				else {
					break _loop48;
				}
				
			} while (true);
			}
			loc_AST = (AST)currentAST.root;
		}
		catch (RecognitionException ex) {
			reportError(ex);
			consume();
			consumeUntil(_tokenSet_4);
		}
		returnAST = loc_AST;
	}
	
	public final void bool() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST bool_AST = null;
		
		try {      // for error handling
			join();
			astFactory.addASTChild(currentAST, returnAST);
			{
			_loop51:
			do {
				if ((LA(1)==OR)) {
					AST tmp65_AST = null;
					tmp65_AST = astFactory.create(LT(1));
					astFactory.makeASTRoot(currentAST, tmp65_AST);
					match(OR);
					join();
					astFactory.addASTChild(currentAST, returnAST);
				}
				else {
					break _loop51;
				}
				
			} while (true);
			}
			bool_AST = (AST)currentAST.root;
		}
		catch (RecognitionException ex) {
			reportError(ex);
			consume();
			consumeUntil(_tokenSet_5);
		}
		returnAST = bool_AST;
	}
	
	public final void join() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST join_AST = null;
		
		try {      // for error handling
			equality();
			astFactory.addASTChild(currentAST, returnAST);
			{
			_loop54:
			do {
				if ((LA(1)==AND)) {
					AST tmp66_AST = null;
					tmp66_AST = astFactory.create(LT(1));
					astFactory.makeASTRoot(currentAST, tmp66_AST);
					match(AND);
					equality();
					astFactory.addASTChild(currentAST, returnAST);
				}
				else {
					break _loop54;
				}
				
			} while (true);
			}
			join_AST = (AST)currentAST.root;
		}
		catch (RecognitionException ex) {
			reportError(ex);
			consume();
			consumeUntil(_tokenSet_6);
		}
		returnAST = join_AST;
	}
	
	public final void equality() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST equality_AST = null;
		
		try {      // for error handling
			rel();
			astFactory.addASTChild(currentAST, returnAST);
			{
			_loop58:
			do {
				if ((LA(1)==EQ||LA(1)==NE)) {
					{
					switch ( LA(1)) {
					case EQ:
					{
						AST tmp67_AST = null;
						tmp67_AST = astFactory.create(LT(1));
						astFactory.makeASTRoot(currentAST, tmp67_AST);
						match(EQ);
						break;
					}
					case NE:
					{
						AST tmp68_AST = null;
						tmp68_AST = astFactory.create(LT(1));
						astFactory.makeASTRoot(currentAST, tmp68_AST);
						match(NE);
						break;
					}
					default:
					{
						throw new NoViableAltException(LT(1), getFilename());
					}
					}
					}
					rel();
					astFactory.addASTChild(currentAST, returnAST);
				}
				else {
					break _loop58;
				}
				
			} while (true);
			}
			equality_AST = (AST)currentAST.root;
		}
		catch (RecognitionException ex) {
			reportError(ex);
			consume();
			consumeUntil(_tokenSet_7);
		}
		returnAST = equality_AST;
	}
	
	public final void rel() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST rel_AST = null;
		
		try {      // for error handling
			expr();
			astFactory.addASTChild(currentAST, returnAST);
			{
			_loop62:
			do {
				if ((_tokenSet_8.member(LA(1)))) {
					{
					switch ( LA(1)) {
					case LT:
					{
						AST tmp69_AST = null;
						tmp69_AST = astFactory.create(LT(1));
						astFactory.makeASTRoot(currentAST, tmp69_AST);
						match(LT);
						break;
					}
					case LE:
					{
						AST tmp70_AST = null;
						tmp70_AST = astFactory.create(LT(1));
						astFactory.makeASTRoot(currentAST, tmp70_AST);
						match(LE);
						break;
					}
					case GT:
					{
						AST tmp71_AST = null;
						tmp71_AST = astFactory.create(LT(1));
						astFactory.makeASTRoot(currentAST, tmp71_AST);
						match(GT);
						break;
					}
					case GE:
					{
						AST tmp72_AST = null;
						tmp72_AST = astFactory.create(LT(1));
						astFactory.makeASTRoot(currentAST, tmp72_AST);
						match(GE);
						break;
					}
					default:
					{
						throw new NoViableAltException(LT(1), getFilename());
					}
					}
					}
					expr();
					astFactory.addASTChild(currentAST, returnAST);
				}
				else {
					break _loop62;
				}
				
			} while (true);
			}
			rel_AST = (AST)currentAST.root;
		}
		catch (RecognitionException ex) {
			reportError(ex);
			consume();
			consumeUntil(_tokenSet_9);
		}
		returnAST = rel_AST;
	}
	
	public final void expr() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST expr_AST = null;
		
		try {      // for error handling
			term();
			astFactory.addASTChild(currentAST, returnAST);
			{
			_loop66:
			do {
				if ((LA(1)==PLUS||LA(1)==MINUS)) {
					{
					switch ( LA(1)) {
					case PLUS:
					{
						AST tmp73_AST = null;
						tmp73_AST = astFactory.create(LT(1));
						astFactory.makeASTRoot(currentAST, tmp73_AST);
						match(PLUS);
						break;
					}
					case MINUS:
					{
						AST tmp74_AST = null;
						tmp74_AST = astFactory.create(LT(1));
						astFactory.makeASTRoot(currentAST, tmp74_AST);
						match(MINUS);
						break;
					}
					default:
					{
						throw new NoViableAltException(LT(1), getFilename());
					}
					}
					}
					term();
					astFactory.addASTChild(currentAST, returnAST);
				}
				else {
					break _loop66;
				}
				
			} while (true);
			}
			expr_AST = (AST)currentAST.root;
		}
		catch (RecognitionException ex) {
			reportError(ex);
			consume();
			consumeUntil(_tokenSet_10);
		}
		returnAST = expr_AST;
	}
	
	public final void term() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST term_AST = null;
		
		try {      // for error handling
			unary();
			astFactory.addASTChild(currentAST, returnAST);
			{
			_loop70:
			do {
				if ((LA(1)==MUL||LA(1)==DIV)) {
					{
					switch ( LA(1)) {
					case MUL:
					{
						AST tmp75_AST = null;
						tmp75_AST = astFactory.create(LT(1));
						astFactory.makeASTRoot(currentAST, tmp75_AST);
						match(MUL);
						break;
					}
					case DIV:
					{
						AST tmp76_AST = null;
						tmp76_AST = astFactory.create(LT(1));
						astFactory.makeASTRoot(currentAST, tmp76_AST);
						match(DIV);
						break;
					}
					default:
					{
						throw new NoViableAltException(LT(1), getFilename());
					}
					}
					}
					unary();
					astFactory.addASTChild(currentAST, returnAST);
				}
				else {
					break _loop70;
				}
				
			} while (true);
			}
			term_AST = (AST)currentAST.root;
		}
		catch (RecognitionException ex) {
			reportError(ex);
			consume();
			consumeUntil(_tokenSet_11);
		}
		returnAST = term_AST;
	}
	
	public final void unary() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST unary_AST = null;
		
		try {      // for error handling
			switch ( LA(1)) {
			case MINUS:
			{
				AST tmp77_AST = null;
				tmp77_AST = astFactory.create(LT(1));
				astFactory.makeASTRoot(currentAST, tmp77_AST);
				match(MINUS);
				unary();
				astFactory.addASTChild(currentAST, returnAST);
				unary_AST = (AST)currentAST.root;
				unary_AST.setType(NEGATE);
				unary_AST = (AST)currentAST.root;
				break;
			}
			case NOT:
			{
				AST tmp78_AST = null;
				tmp78_AST = astFactory.create(LT(1));
				astFactory.makeASTRoot(currentAST, tmp78_AST);
				match(NOT);
				unary();
				astFactory.addASTChild(currentAST, returnAST);
				unary_AST = (AST)currentAST.root;
				break;
			}
			case NUM:
			case LPAREN:
			case ID:
			case REAL:
			case LITERAL_true:
			case LITERAL_false:
			{
				factor();
				astFactory.addASTChild(currentAST, returnAST);
				unary_AST = (AST)currentAST.root;
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
		}
		catch (RecognitionException ex) {
			reportError(ex);
			consume();
			consumeUntil(_tokenSet_12);
		}
		returnAST = unary_AST;
	}
	
	public final void factor() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST factor_AST = null;
		
		try {      // for error handling
			switch ( LA(1)) {
			case LPAREN:
			{
				match(LPAREN);
				bool();
				astFactory.addASTChild(currentAST, returnAST);
				match(RPAREN);
				factor_AST = (AST)currentAST.root;
				break;
			}
			case ID:
			{
				loc();
				astFactory.addASTChild(currentAST, returnAST);
				factor_AST = (AST)currentAST.root;
				break;
			}
			case NUM:
			{
				AST tmp81_AST = null;
				tmp81_AST = astFactory.create(LT(1));
				astFactory.addASTChild(currentAST, tmp81_AST);
				match(NUM);
				factor_AST = (AST)currentAST.root;
				break;
			}
			case REAL:
			{
				AST tmp82_AST = null;
				tmp82_AST = astFactory.create(LT(1));
				astFactory.addASTChild(currentAST, tmp82_AST);
				match(REAL);
				factor_AST = (AST)currentAST.root;
				break;
			}
			case LITERAL_true:
			{
				AST tmp83_AST = null;
				tmp83_AST = astFactory.create(LT(1));
				astFactory.addASTChild(currentAST, tmp83_AST);
				match(LITERAL_true);
				factor_AST = (AST)currentAST.root;
				break;
			}
			case LITERAL_false:
			{
				AST tmp84_AST = null;
				tmp84_AST = astFactory.create(LT(1));
				astFactory.addASTChild(currentAST, tmp84_AST);
				match(LITERAL_false);
				factor_AST = (AST)currentAST.root;
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
		}
		catch (RecognitionException ex) {
			reportError(ex);
			consume();
			consumeUntil(_tokenSet_12);
		}
		returnAST = factor_AST;
	}
	
	
	public static final String[] _tokenNames = {
		"<0>",
		"EOF",
		"<2>",
		"NULL_TREE_LOOKAHEAD",
		"WHITESPACE",
		"DIGITS",
		"NUM",
		"AND",
		"LE",
		"SEMI",
		"OR",
		"GT",
		"LPAREN",
		"ASSIGN",
		"GE",
		"RPAREN",
		"EQ",
		"LBRACE",
		"PLUS",
		"NOT",
		"RBRACE",
		"MINUS",
		"NE",
		"LBRACK",
		"MUL",
		"LT",
		"RBRACK",
		"DIV",
		"ID",
		"NEGATE",
		"DECLS",
		"\"int\"",
		"\"char\"",
		"\"bool\"",
		"\"float\"",
		"\"if\"",
		"\"else\"",
		"\"while\"",
		"\"do\"",
		"\"break\"",
		"REAL",
		"\"true\"",
		"\"false\""
	};
	
	protected void buildTokenTypeASTClassMap() {
		tokenTypeToASTClassMap=null;
	};
	
	private static final long[] mk_tokenSet_0() {
		long[] data = { 996700979712L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_0 = new BitSet(mk_tokenSet_0());
	private static final long[] mk_tokenSet_1() {
		long[] data = { 1065421505024L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_1 = new BitSet(mk_tokenSet_1());
	private static final long[] mk_tokenSet_2() {
		long[] data = { 996702028288L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_2 = new BitSet(mk_tokenSet_2());
	private static final long[] mk_tokenSet_3() {
		long[] data = { 1028914283008L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_3 = new BitSet(mk_tokenSet_3());
	private static final long[] mk_tokenSet_4() {
		long[] data = { 258338688L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_4 = new BitSet(mk_tokenSet_4());
	private static final long[] mk_tokenSet_5() {
		long[] data = { 67142144L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_5 = new BitSet(mk_tokenSet_5());
	private static final long[] mk_tokenSet_6() {
		long[] data = { 67143168L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_6 = new BitSet(mk_tokenSet_6());
	private static final long[] mk_tokenSet_7() {
		long[] data = { 67143296L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_7 = new BitSet(mk_tokenSet_7());
	private static final long[] mk_tokenSet_8() {
		long[] data = { 33573120L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_8 = new BitSet(mk_tokenSet_8());
	private static final long[] mk_tokenSet_9() {
		long[] data = { 71403136L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_9 = new BitSet(mk_tokenSet_9());
	private static final long[] mk_tokenSet_10() {
		long[] data = { 104976256L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_10 = new BitSet(mk_tokenSet_10());
	private static final long[] mk_tokenSet_11() {
		long[] data = { 107335552L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_11 = new BitSet(mk_tokenSet_11());
	private static final long[] mk_tokenSet_12() {
		long[] data = { 258330496L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_12 = new BitSet(mk_tokenSet_12());
	
	}
