#!/usr/bin/perl -w
#
# Regression testing script. 
# Takes as input sample program.
# Assumptions:
# 	1) Desired output file starts with sample filename and ends with .out.
# 	2) Program executed from main project directory (trunk/).
#

use strict;
#use Term::ScreenColor;
use vars qw [ $samp_dir $samp $tableGen $faillog ];

$faillog = "testfail.log";

$samp_dir = "samples/";
$samp = $samp_dir . $ARGV[0];

$tableGen = "./TableGen";

&testPreprocessor;
&testIntermediate;
&testPlainOut;
&testLatexOut;
&testHtmlOut;

system ("rm -rf $samp_dir*.real");

sub testPreprocessor {
	my $opt = "--only-preprocess";
	my $real_out = `$tableGen $opt $samp`;

	my @real_out = &printReal ($real_out);
	&diff ("$samp.real", "$samp.out.pre", "Preprocessor Output", $real_out, $opt);
}

sub testIntermediate {
	my $opt = "--only-intermediate";
        my $real_out = `$tableGen $opt $samp`;

        &printReal ($real_out);
        &diff ("$samp.real", "$samp.out.inter", "Intermediate Output", $real_out, $opt);
}

sub testPlainOut {
	my $opt = "";
	my $real_out = `$tableGen $samp`;

	&printReal ($real_out);
	&diff ("$samp.real", "$samp.out", "Plain Text Output", $real_out, $opt);
}

sub testLatexOut {
	my $opt = "--output-type latex";
        my $real_out = `$tableGen $opt $samp`;

        &printReal ($real_out);
        &diff ("$samp.real", "$samp.out.latex", "LaTeX Output", $real_out, $opt);
}

sub testHtmlOut {
	my $opt = "--output-type html";
        my $real_out = `$tableGen $opt $samp`;

        &printReal ($real_out);
        &diff ("$samp.real", "$samp.out.html", "HTML Output", $real_out, $opt);
}

# Helper routines.
sub printReal {
	my $out = shift;
	
	open REAL, ">$samp.real" or die "Can't open $samp.real: $!";

	print REAL $out;
}

sub diff {
	my $real = shift;
	my $good = shift;
	my $type = shift;
	my $out = shift;
	my $opt = shift;

	if (! -e $good) {
		print "Nothing to compare: need $good: ";
		print "FAIL\n";
		return;
	}

	my $diff = `diff $real $good`;
	my @diff = split /\n/, $diff;

	#my $scr = new Term::ScreenColor;
	if (!@diff) {
		# Real output matched desired output.
                print "$type Test: ";
		#$scr->raw ();
		#$scr->putcolored('green', "OK\n");
		print "OK\n";
	} else {
		print "$type Test: FAIL (see $faillog)\n";
		open FAIL, ">>testfail.log" or die "Can't open testfail.log: $!";
		print FAIL "=====$type Test Failed on $samp=====\n\nDiff: \n";
		print FAIL "$_\n" for (@diff);
		print FAIL "\n\nCommand run: $tableGen $opt $samp\n";
		print FAIL "\n\nReal output: \n";
		print FAIL $_ for ($out);
		print FAIL "\n\nExpected output: \n";
		open EXP, "$good";
		print FAIL <EXP>;
		print FAIL "\n" x 5;
		close FAIL;
		close EXP;
	}
}
