#!/usr/bin/perl
#
# This script does one of two things. If passed an agrument is will add the program to the 
# test suite.
#
# If no argument is passed, this script will search the samples directory for files that 
# part of the testing suite. 
#
# RUN THIS FROM TRUNK

use strict;
use vars qw [ @prog @MAKE @existing ];

@prog = @ARGV if (@ARGV);

if (!@prog) {
	@prog = glob "samples/*.tg";
}

for (@prog) {
	s/samples\///;
	s/\.tg//;
}

open MAKEFILE, "Makefile" or die "Couldn't open Makefile: $!";
my @MAKE = <MAKEFILE>;
close MAKEFILE;

@existing = &findExistingTests;

for my $prog (@prog) {
	&addProg ($prog) if (! &progExists ($prog));
}


sub findExistingTests {
	my @existing;
	my $test = 0;
	for (@MAKE) {
		$test = 1 if (/^test: /);
		next if (!$test);

		if (/^(.+):/) {
			push @existing, $1;
		}
	}

	return @existing;
}

sub progExists {
	my $prog = shift;
	for (@existing) {
		return 1 if ($prog eq $_);
	}

	return 0;
}

sub addProg {
	my $prog = shift;
	
	for (@MAKE) {
		s/^test: (.+)$/test: $1 $prog/;
	}

	push @MAKE, "$prog: \n";
	push @MAKE, "\t\@echo \"Running $prog test...\"\n";
	push @MAKE, "\t\@\${reg_test} $prog.tg\n";
	push @MAKE, "\t\@echo =======================================\n";
	push @MAKE, "\n";

	open MAKEFILE, ">Makefile";
	for (@MAKE) {
		print MAKEFILE $_;
	}
}
