package symtb;

import java.util.LinkedList;
import java.util.ListIterator;

public class TGScope {
    public static final TGScope NULL_SCOPE = null;

    private TGScope parentScope;
    private LinkedList<TGScope> childrenScopes;
    private LinkedList<TGHash> symbols;
    private int childIterator;
    
    public TGScope(TGScope parentScope){
        this.parentScope = parentScope;
        if (parentScope != null)
        	parentScope.addToChildrenScopes(this);
        this.childrenScopes = new LinkedList<TGScope>();
        this.symbols = new LinkedList<TGHash>();
        this.childIterator = 0;
    }
    
    public TGScope getNextChildScope(){
        if (childIterator == this.childrenScopes.size())
        	childIterator = 0;
        return childrenScopes.get(childIterator++);
    }
    
    public void resetScopeIterator() {
    	childIterator = 0;
    }
    
    public LinkedList<TGScope> getChildrenScopes() {
    	return childrenScopes;
    }
    
    public int getNumChildScopes(){
        return this.childrenScopes.size();
    }
    
    public int getNumSymbols(){
        return this.symbols.size();
    }
    
    public TGHash getSymbol(int i){
        return symbols.get(i);
    }
    
    public TGScope getChildScope(int i){
        return childrenScopes.get(i);
    }
    
    public TGScope getParentScope(){
        return parentScope;
    }
    
    public int getSymbolType(String name){
        for (int i = 0; i < symbols.size(); i++){
            if (symbols.get(i).getName().equals(name))
                return symbols.get(i).getType();
        }
        return 0;
    }
    
    public boolean containsSymbol(String name){
        for (int i = 0; i < symbols.size(); i++){
            if (symbols.get(i).getName().equals(name))
                return true;
        }
        return false;
    }

    /**
     * Adds the given scope to the list of children for the scope called on
     * and also makes the scope called on the parent of the scope passed as
     * a parameter
     * @param s the scope to add to the list of children
     */
    public void addToChildrenScopes(TGScope s) {
        this.childrenScopes.addLast(s);
        s.setParentScope(this);
    }

    public void addSymbol(TGHash s) {
        this.symbols.add(s);
    }
    
    /**
     * Makes a new symbol of the specified type and adds it to the scope
     * @param name the name of the symbol to add
     * @param type the type of the symbol to add as declared in TGSymbol
     */
    public void addSymbol(String name, int type) {
    	this.addSymbol(new TGHash(name, type));
    }

    public TGHash[] getSymbols() {
    	TGHash[] result = new TGHash[symbols.size()];
    	result = symbols.toArray(result);
        return result;
    }
    
    public String toString() {
    	int i;
    	String result = "";
    	TGHash[] symbols = new TGHash[this.symbols.size()];
    	symbols = this.symbols.toArray(symbols);
    	
    	if (symbols.length > 0) {
    		for (i = 0; i < symbols.length - 1; i++)
        		result += symbols[i].getName() + ", ";
        	result += symbols[i].getName();
    	}
    	
    	return result;
    }
    
    void setParentScope(TGScope s) {
    	this.parentScope = s;
    }
}
