package symtb;

public class TGNum {
    
    public static final int INT = 1;
    public static final int DOUBLE = 2;
    
    private int type;
    private Object value;


    public TGNum(Integer i){
        type = INT;
        value = i;
    }

    public TGNum(Double d){
        type = DOUBLE;
        value = d;
    }
    
    public TGNum(int i) {
    	type = INT;
    	value = new Integer(i);
    }
    
    public TGNum(double d) {
    	type = DOUBLE;
    	value = new Double(d);
    }

    public boolean isInt(){
        return (type == INT);
    }

    public boolean isDouble(){
        return (type == DOUBLE);
    }

    public int getIntValue(){
        return ((Integer)value).intValue();
    }

    public double getDoubleValue(){
        return ((Double)value).doubleValue();
    }

    public void setValue(int i){
        type = INT;
        value = new Integer(i);
    }

    public void setValue(double d){
        type = DOUBLE;
        value = new Double(d);
    }
    
    public String toString() {
    	if (this.type == DOUBLE)
    		return ((Double)(this.value)).toString();
    	else
    		return ((Integer)(this.value)).toString();
    }
}
