#!/usr/bin/perl

# When wrote our examples, we were not careful about the 
# fact that our language counts the number of tabs instead 
# of spaces. This scipt removes all leading spaces and 
# replacs with tabs.
use strict;

my $file = pop @ARGV;

open FILE, $file or die "Unable to open $file: $!\n";

my @FILE = <FILE>;

close FILE;

open OUT, ">$file" or die "Unable to reopen $file: $!\n";
select OUT;

my $firstIndent = 0;
for (@FILE) {
	if ($firstIndent && /^\s+\w/) {
		my $spaces = " " x $firstIndent;
		s/\t/$spaces/g;
	}
	if (/(^\ +)/) {
		my $numSpaces = int (split "", $1);
		$firstIndent = $numSpaces if (!$firstIndent);
		s/^\ +//;
		print "\t" x int ($numSpaces / $firstIndent);
		print "$_";
		next;
	}
	print $_;
}

