package main;

import java.io.*;
import java.util.*;
import org.antlr.runtime.*;
import org.antlr.runtime.tree.*;

import excep.*;

import gram.TableGenLexer;
import gram.TableGenParser;
import symtb.*;

public class TableGen {

	public static boolean debug = false;

	public static void main(String[] args) {
		
		try {
			CharStream cs = new ANTLRFileStream(args[0]);
			TableGenLexer lexer = new TableGenLexer(cs);
			
			CommonTokenStream tokens = new CommonTokenStream();
			tokens.setTokenSource(lexer);
			
			TableGenParser parser = new TableGenParser(tokens);
			
			TableGenParser.program_return r = parser.program();
			CommonTree t = (CommonTree)r.getTree();
			
			if (debug)
				System.out.println(t.toStringTree());
			
	        TGAbstractSymbolTable abstractSymbolTable = new TGAbstractSymbolTable (t);
	        abstractSymbolTable.build();
		if (debug)
	        	abstractSymbolTable.printScopes();
	        
		if (debug)
	        	System.out.println("\n-----------------------------------------------\n");
	        
	        Interpreter interpreter = new Interpreter(t, abstractSymbolTable);
	        interpreter.interpret();
		}
		catch (IOException e) {
			System.out.println("Error getting data from file: " + e.getMessage());
			System.exit(1);
		}
		catch (RecognitionException e) {
			System.out.println("Recognition Exception received");
			System.exit(2);
		}
		
	}

}
