/**
 * Wrapper class for generic data in the Graphr Language
 * @author Paul Dix
 */
public class GraphrDataType {
	/**
	 * Returns a new GraphrDataType representing this GraphrDataType concatenated with rVal.
	 * @param rVal - the GraphrDataType to add.
	 * @returns the result of concatenating this GraphrNumber with rVal.
	 */
	public GraphrDataType add(GraphrDataType rVal) {
		return new GraphrString(this.toString() + rVal.toString());
	}
	
	/**
	 * Returns this GraphrDataType.
	 * @param rVal - the GraphrDataType to subtract.
	 * @returns this GraphrDataType.
	 */
	public GraphrDataType subtract(GraphrDataType rVal) {
		return this;
	}
	
	/**
	 * Returns this GraphrDataType.
	 * @param rVal - the GraphrDataType to multiply by.
	 * @returns this GraphrDataType.
	 */
	public GraphrDataType multiply(GraphrDataType rVal) {
		return this;
	}
	
	/**
	 * Returns this GraphrDataType.
	 * @param rVal - the GraphrDataType to divide by.
	 * @returns this GraphrDataType.
	 */
	public GraphrDataType divide(GraphrDataType rVal) {
		return this;
	}
	
	/**
	 * Returns new GraphrBoolean that equals true.
	 * @returns new GraphrBoolean that equals true.
	 */
	public Boolean toBoolean() {
		return new Boolean(true);
	}
	
	/**
	 * Returns new GraphrBoolean that equals false.
	 * @param rVal - the GraphrDataType to compare with.
	 * @returns new GraphrBoolean that equals false.
	 */
	public GraphrBoolean equals(GraphrDataType rVal) {
	  if (this.getClass() == GraphrNumber.class) {
	    return ((GraphrNumber)this).equals(rVal);
	  }
	  else if (this.getClass() == GraphrString.class) {
	    return ((GraphrString)this).equals(rVal);
	  }
	  else if (this.getClass() == GraphrArray.class) {
	    return ((GraphrArray)this).equals(rVal);
	  }
	  else {
	    return ((GraphrAssociativeArray)this).equals(rVal);
	  }
	}
	
	/**
	 * Returns new GraphrBoolean that equals false.
	 * @param rVal - the GraphrDataType to compare with.
	 * @returns new GraphrBoolean that equals false.
	 */
	public GraphrBoolean lessThan(GraphrDataType rVal) {
		return new GraphrBoolean(false);
	}
	
	/**
	 * Returns new GraphrBoolean that equals false.
	 * @param rVal - the GraphrDataType to compare with.
	 * @returns new GraphrBoolean that equals false.
	 */
	public GraphrBoolean greaterThan(GraphrDataType rVal) {
		return new GraphrBoolean(false);
	}
	
	/**
	 * Returns new GraphrBoolean that equals false.
	 * @param rVal - the GraphrDataType to compare with.
	 * @returns new GraphrBoolean that equals false.
	 */
	public GraphrBoolean lessThanEqualTo(GraphrDataType rVal) {
		return new GraphrBoolean(false);
	}
	
	/**
	 * Returns new GraphrBoolean that equals false.
	 * @param rVal - the GraphrDataType to compare with.
	 * @returns new GraphrBoolean that equals false.
	 */
	public GraphrBoolean greaterThanEqualTo(GraphrDataType rVal) {
		return new GraphrBoolean(false);
	}
	
	/**
	 * Returns the left hand operand unless the child class overloads this.
	 * @param rVal - the GraphrDataType to mod with.
	 * @returns this (left hand operand).
	 */
	public GraphrDataType mod(GraphrDataType rVal) {
	  return this;
	}
}