import java.util.ArrayList;

/**
 * Interface for arrays and associative arrays in the Graphr Language
 * @author Paul Dix
 */
public interface GraphrCollection {
	/**
	 * Returns the GraphrDataType at the location provided by key.
	 * @param key -the key whose associated value is to be returned.
	 * @returns GraphrDataType at the location provided by key.
	 */
	public GraphrDataType getValueAt(GraphrDataType key);
	
	/**
	 * Associates the specified value with the specified key in this collection.
	 * @param key - key with which the specified value is to be associated.
   * @param value - value to be associated with the specified key.
	 */
	public void setValueAt(GraphrDataType key, GraphrDataType value);
	
	public ArrayList<GraphrDataType> getArray();
}