/**
 * Wrapper class for booleans in the Graphr Language
 * @author Paul Dix
 */
public class GraphrBoolean extends GraphrDataType {
	//Variable declaration
	private Boolean bool;
	
	/**
	 * Constructs a newly allocated GraphrBoolean object that represents the primitive boolean argument.
	 * @param b - the boolean to be represented by the GraphrBoolean.
	 */
	public GraphrBoolean(boolean b) {
		this.bool = b;
	}
	
	/**
	 * Returns the boolean value of this GraphrBoolean object.
	 * @returns the boolean value of this GraphrBoolean object.
	 */
	public Boolean getBoolean() {
		return this.bool;
	}
	
	/**
	 * Returns a string representation of the object.
	 * @returns a string representation of the object.
	 */
	public String toString() {
		return this.bool.toString();
	}
	
	/**
	 * Returns the negation of this boolean.
	 * @returns the negation of this boolean.
	 */
	public GraphrBoolean not() {
	  if (this.bool) {
	    return new GraphrBoolean(false);
	  }
	  else {
	    return new GraphrBoolean(true);
	  }
	}
}